/*
 * Copyright(C) 2015 SJNKS Corporation, All rights reserved.
 * $Id$
 * @fileoverview shomeiWindow.js 署名制御画面
 * @author SJNKS 中川
 */

/*
 * 概要：デバイス選択ポップアップ[キャンセル]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("deviceSelectButtonCancel", function (ev) {
	// ポップアップを閉じる
	shomeiUtil.shomeiWindowObj.popup("close");
});

/*
 * 概要：デバイス選択ポップアップ[選択]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("deviceSelectButtonOk", function (ev) {
	// 選択されたデバイス種類を保存
	shomeiCommon.setDeviceType($("input[name=deviceSelect]:checked").val());
	if (initShomeiWindow()){
		shomeiUtil.shomeiWindowObj.popup("close"); // ポップアップを閉じて開き直すことにより、表示位置を再計算させる
		shomeiUtil.shomeiWindowObj.popup("open");
	} else {
		shomeiUtil.shomeiWindowObj.popup("close");
	}
});

/*
 * 概要：使用デバイス確認処理
 */
function initShomeiWindow() {

	// ブラウザ種別の取得
	shomeiCommon.checkBrowser();

	// 開発モードの場合、マウス操作を強制許可
	if (paperless._options.developmode) {
		isMouseAvailable = true;
	}

	// 非対面操作の場合、マウス署名ON
	if (paperless.util.isHitaimenkb) {
		isMouseAvailable = true;
	}

	// 署名画面の表示処理
	if (!useDeviceInit()) {
		return false;
	}
	var selectedDevice = shomeiCommon.getDeviceType();
	if (!selectedDevice) {
		paperless.control.hide("inputWindowInkTool");
		paperless.control.hide("inputWindowCanvas");
		paperless.control.show("inputWindowDevice");
		deviceSelectInit();
		return true;
	}
	var isPopupWindow = false;
	paperless.control.hide("inputWindowDevice");
	switch (selectedDevice) {
		case deviceType.PEN_TABLET:
		case deviceType.TOUCH_DEVICE:
		case deviceType.MOUSE:
			isPopupWindow = shomeiCanvas.initCanvas();
			break;
		case deviceType.INK_TOOL:
			isPopupWindow = shomeiInkTool.inkToolInit();
			break;
		default:
			break;
	}
	return isPopupWindow;
}

/*
 * 概要：使用デバイス選択状態の初期化処理
 */
function useDeviceInit() {
	// 使用可能デバイス数を取得
	var deviceCount = shomeiCommon.getDeviceCount();
	
	var selectedDevice = shomeiCommon.getDeviceType();

	if (deviceCount < 2) {
		if (isWebPluginAvailable) {
			shomeiCommon.setDeviceType( deviceType.PEN_TABLET);
		} else if (isTouchAvailable) {
			shomeiCommon.setDeviceType(deviceType.TOUCH_DEVICE);
		} else if (isInkToolAvailable) {
			// 非対面操作 マウス署名可能、かつ、サインタブレットも使えるけど接続されていない場合は
			// デバイスタイプをマウスにする。
			//if (isMouseAvailable && shomeiInkTool.isSignPadConnect($("#InkTool")[0]) == -1){
			if (paperless.util.isHitaimenkb && shomeiInkTool.isSignPadConnect($("#InkTool")[0]) == -1){
				shomeiCommon.setDeviceType(deviceType.MOUSE);
			} else {
				shomeiCommon.setDeviceType(deviceType.INK_TOOL);
			}
		} else if (isMouseAvailable) {
			shomeiCommon.setDeviceType(deviceType.MOUSE);
		} else {
			// ポップアップを閉じる
			shomeiUtil.shomeiWindowObj.popup("close");
			if (paperless.util.isTestMode) {
				alert("使用可能な署名デバイスがありません。\nテストモードの場合は署名を省略可能です。");
			} else {
				alert("使用可能な署名デバイスがありません。");
			}
			return false;
		}
		// 1度使用したデバイスが、使用不可になった場合デバイス選択画面を表示
	} else if (selectedDevice) {
		if (selectedDevice == deviceType.PEN_TABLET) {
			if (!shomeiCommon.checkWebPluginAvailable()) {
				shomeiCommon.removeDeviceType();
			} else if (isInkToolAvailable && shomeiInkTool.isSignPadConnect($("#InkTool")[0]) > 0){
				if (!(this.event.srcElement && 
						this.event.srcElement.parentElement &&
						this.event.srcElement.parentElement.id == "deviceSelectButtonOk")){
					shomeiCommon.removeDeviceType();
				}
			}
		} else if (selectedDevice == deviceType.TOUCH_DEVICE) {
			if (!shomeiCommon.checkTouchAvailable()) {
				shomeiCommon.removeDeviceType();
			}
			// インクツールが接続されていないとき
		} else if (selectedDevice == deviceType.INK_TOOL){
			if (!isInkToolAvailable){
				shomeiCommon.removeDeviceType();
			} else if (shomeiInkTool.isSignPadConnect($("#InkTool")[0]) == -1){
				shomeiCommon.removeDeviceType();
			}
		}
	}
	return true;
}

/*
 * 概要：デバイス選択ポップアップ表示処理
 */
function deviceSelectInit() {
	shomeiUtil.shomeiWindowObj.addClass("device-select-window");
	shomeiUtil.shomeiWindowObj.removeClass("shomei-window");
	shomeiUtil.shomeiWindowObj.removeClass("ink-tool300-window");
	shomeiUtil.shomeiWindowObj.removeClass("ink-tool430-window");

	// 使用可能デバイスの取得
	shomeiCommon.getDeviceCount();

	// 各デバイスの活性/非活性判断
	if (isInkToolAvailable) {
		paperless.control.enable("deviceSelect1");
	} else {
		paperless.control.disable("deviceSelect1");
	}
	if (isWebPluginAvailable) {
		paperless.control.enable("deviceSelect2");
	} else {
		paperless.control.disable("deviceSelect2");
	}
	if (isTouchAvailable) {
		paperless.control.enable("deviceSelect3");
	} else {
		paperless.control.disable("deviceSelect3");
	}
	if (isMouseAvailable) {
		paperless.control.enable("deviceSelect4");
	} else {
		paperless.control.disable("deviceSelect4");
	}
	
	$("#deviceSelect1").checkboxradio().checkboxradio("refresh");
	$("#deviceSelect2").checkboxradio().checkboxradio("refresh");
	$("#deviceSelect3").checkboxradio().checkboxradio("refresh");
	$("#deviceSelect4").checkboxradio().checkboxradio("refresh");
	
	// 選択ボタン活性/非活性判断
	if (!$("[name='deviceSelect']").is(":checked")){
		paperless.control.disable("deviceSelectButtonOk");
	}
}

/*
 * 概要：canvasの[クリア]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("clear", function (ev) {
	shomeiCanvas.inputCanvasClear();
});

/*
 * 概要：canvasの[確定する]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("kakutei", function (ev) {
	shomeiCanvas.inputCanvasOk();
});

/*
 * 概要：InkToolの[クリア]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("clearInkTool", function (ev) {
	shomeiInkTool.inkToolClear($("#InkTool")[0]);
});

/*
 * 概要：InkToolの[OK]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("okInkTool", function (ev) {
	shomeiInkTool.inkToolOk();
});

/*
 * 概要：[×]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("batsu", function (ev) {
	// ポップアップを閉じる
	shomeiUtil.shomeiWindowObj.popup("close");
});

/*
 * 概要：[デバイス選択]ラジオボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.change("deviceSelect1, deviceSelect2, deviceSelect3, deviceSelect4", function (ev) {
	// 活性・非活性制御
	if ($("[name=deviceSelect]").is(":checked")) {
		paperless.control.enable("deviceSelectButtonOk");
	} else {
		paperless.control.disable("deviceSelectButtonOk");
	}
});
