/*
 * Copyright(C) 2015 SJNKS Corporation, All rights reserved.
 * $Id$
 * @fileoverview shomeiUtil.js 署名制御画面
 * @author SJNKS 中川
 */

/*
 * 概要：署名画面共通変数です。
 */
var shomeiUtil = {
	mainCanvasObj : null,
	shomeiWindowObj : null,
	mainCanvasShomeiDataObj : null,
	shomeiWindowClass : ""
};

/*
 * 概要：署名画面共通変数を設定します。
 * @param {object} 署名内容キャンバスオブジェクト
 * @param {object} 署名ウィンドウオブジェクト
 * @param {object} 署名文字列(隠し項目)オブジェクト
 * @param {String} 署名ウィンドウクラス
 */
function init(mainCanvasObj, shomeiWindowObj, mainCanvasShomeiDataObj, shomeiWindowClass) {
	shomeiUtil.mainCanvasObj = mainCanvasObj;
	shomeiUtil.shomeiWindowObj = shomeiWindowObj;
	shomeiUtil.mainCanvasShomeiDataObj = mainCanvasShomeiDataObj;
	shomeiUtil.shomeiWindowClass = shomeiWindowClass;
}

/*
 * 概要：ポップアップ初期表示処理を行います。
 */

function initWindow() {
	shomeiUtil.shomeiWindowObj.load("GHPCA220.html", function() {
		// ポップアップを表示する
		if (initShomeiWindow()){
			shomeiUtil.shomeiWindowObj.popup("open");
		} else {
			shomeiUtil.shomeiWindowObj.popup("close");
		}
	});
}

/*
 * 概要：初期表示の時、文字列から画像に復元します。
 */
function restoreImage() {
	shomeiCommon.restore(shomeiUtil.mainCanvasShomeiDataObj.val());
}

/*
 * 概要：テストモードの時、画像を文字列に変換します。
 */
function outputString() {
	if (paperless.util.isTestMode
		&& shomeiUtil.mainCanvasShomeiDataObj.val() == "") {
		shomeiCommon.clear();
		// base64文字列に出力
		var base64Str = shomeiUtil.mainCanvasObj[0].toDataURL().replace("data:image/png;base64,", "");
		shomeiUtil.mainCanvasShomeiDataObj.val(base64Str);
	}
}

/*
 * 概要：キャンバスおよび文字列を初期化します。
 */
function clearCanvas() {
	shomeiCommon.clear();
	shomeiUtil.mainCanvasShomeiDataObj.val("");
}

/*
 * 概要：個体識別番号を取得します。
 */
function getDeviceInfo(){
	if(shomeiCommon.getDeviceType() == deviceType.INK_TOOL){
		return $("#InkTool")[0].GetSignPadID();
	}else{
		return "";
	}
}

/*
 * 概要：デバイスタイプを取得します。
 */
function getDeviceType(){
	var value = shomeiCommon.getDeviceType();
	if (value == null || value == undefined || value == "") {
		return "";
	} else {
		return value;
	}
}