/*
 * Copyright(C) 2015 SJNKS Corporation, All rights reserved.
 * $Id$
 * @fileoverview shomeiInkTool.js InkTool制御画面
 * @author SJNKS 中川
 */

var shomeiInkTool ={
	/**
	 * InkToolの初期化処理
	 */
	inkToolInit : function() {
		// 画面からInkToolオブジェクトを取得
		var _inkTool = $("#InkTool")[0];	// 描画用InkTool
		var _inkTool2 = $("#InkTool2")[0];	// 書き出し用InkTool

			// InkToolのウィンドウを表示
			paperless.control.show("inputWindowInkTool");
			paperless.control.hide("inputWindowCanvas");
			paperless.control.hide("inputWindowDevice");

			// inkToolのプロパティを設定
			_inkTool.Appearance = 0;
			_inkTool.Enabled = 1;
			_inkTool.UseMouse = 0;

			// inkTool2のプロパティを設定
			_inkTool2.Appearance = 0;
			_inkTool2.Visibled = 0;
			_inkTool2.Enabled = 0;

			// サインタブレット接続状態を取得
			currentInkToolStatus.signTabletType = shomeiInkTool.isSignPadConnect(_inkTool);

			if(currentInkToolStatus.signTabletType == -1) {
				// ポップアップを閉じる
				shomeiUtil.shomeiWindowObj.popup("close");
				alert("サインタブレットが接続されていません。");
				return false;
			} else if(currentInkToolStatus.signTabletType == -2) {
				alert("InkToolの初期化に失敗しました。");
				return false;
			} else {
				// 入力ウインドのInkToolをデバイスに応じてリサイズ
				shomeiInkTool.inkToolAreaResize();
				// ポップアップを閉じる
				shomeiUtil.shomeiWindowObj.popup("close");
			}
			
			// サインタブレット接続状態を取得
			var currentSignPad = shomeiInkTool.isSignPadConnect(_inkTool);
			if(currentSignPad == -1) {
				// ポップアップを閉じる
				alert("サインタブレットが接続されていません。");
				shomeiUtil.shomeiWindowObj.popup("close");
				return false;
			} else if(currentSignPad == -2) {
				// ポップアップを閉じる
				shomeiUtil.shomeiWindowObj.popup("close");
				alert("InkToolの初期化に失敗しました。");
				return false;
			} else if(currentInkToolStatus.signTabletType != currentSignPad) {
				// サインタブレット種別が変更されている場合
				currentInkToolStatus.signTabletType = currentSignPad;
			}

			// 入力ウインドのInkToolをデバイス応じてリサイズ
			shomeiInkTool.inkToolAreaResize();

		// 表示前にInkToolをクリア
		shomeiInkTool.inkToolClear(_inkTool);
		shomeiInkTool.inkToolClear(_inkTool2);

		// inkToolのプロパティを設定
		_inkTool.ScaleW = currentInkToolStatus.ratio;
		_inkTool.ScaleH = currentInkToolStatus.ratio;

		// 機種によってウィンドウのクラスを指定
		switch(currentInkToolStatus.signTabletType) {
			case STU300.TYPE :	// STU300の場合
				shomeiUtil.shomeiWindowObj.addClass("ink-tool300-window");
				$("#InkToolAreaSize").addClass("ink-tool-area300");
				$("#inputWindowInkTool").addClass("input-window-ink-tool300");
				$("#InkToolAreaHeader").addClass("ink-tool-area-header300");
				shomeiUtil.mainCanvasObj.width = "396";
				shomeiUtil.mainCanvasObj.height = "100";
				break;
			case STU430.TYPE : // STU430の場合
				shomeiUtil.shomeiWindowObj.addClass("ink-tool430-window");
				$("#InkToolAreaSize").addClass("ink-tool-area430");
				$("#inputWindowInkTool").addClass("input-window-ink-tool430");
				$("#InkToolAreaHeader").addClass("ink-tool-area-header430");
				shomeiUtil.mainCanvasObj.width = "320";
				shomeiUtil.mainCanvasObj.height = "200";
				break;
			default:
				break;
		}

		shomeiUtil.shomeiWindowObj.removeClass("shomei-window");
		shomeiUtil.shomeiWindowObj.removeClass("device-select-window");
		paperless.control.show("inputWindowInkTool");
		paperless.control.hide("inputWindowCanvas");
		paperless.control.hide("inputWindowDevice");
	
		return true;
	},

	/**
	 * OKボタン押下時の処理
	 */
	inkToolOk : function() {
		// 入力済みかどうかは、ストローク数で判定
		if($("#InkTool")[0].GetStrokeCount() > 0) {
			var _inkTool = $("#InkTool")[0];	// InkTool描画用InkToolオブジェクト
			var base64Str = "";					// 出力するbase64文字列
			var devicePixcelRatio = 1;			// デバイスのピクセル比
			var outputDpi = 96;					// 画像出力時に使用するdpi値

			// ピクセル比からdpiを算出
			if(window.devicePixelRatio) {
				devicePixcelRatio = window.devicePixelRatio;
			} else {
				devicePixcelRatio = window.screen.deviceXDPI / window.screen.logicalXDPI;
			}

			outputDpi = outputDpi / devicePixcelRatio;

			// display:noneの状態だと失敗するため処理中のみ表示
			paperless.control.show("InkTool2");

			var inkData = _inkTool.SaveInkText();	// 描画用InkToolオブジェクトからinkデータ取得
			var _inkTool2 = $("#InkTool2")[0];		// 書き出し用InkToolオブジェクト

			
			// 入力ウインドのデータを書き出し用InkToolオブジェクトに読み込み
			if(_inkTool2.LoadInkText(inkData) == 0) {
				alert("InkTool2の画像読み込みに失敗しました。");
				return;
			}

			// 自動調整処理実行
			if(_inkTool2.DoAdjust(100, 0, 0, 0, 0) == 0) {
				alert("InkTool2の自動調整に失敗しました。");
				return;
			}
			
			// 出力時のdpiを算出
			outputDpi = outputDpi / ($("#InkTool2").width() / defaultX);
			
			// base64文字列に出力
			base64Str = _inkTool2.SaveImageText(1, outputDpi, 0);

			// 署名画面のcanvasに表示
			shomeiUtil.mainCanvasShomeiDataObj.val(base64Str);
			shomeiCommon.restore(base64Str);

			// 入力ウインド初期化
			shomeiInkTool.inkToolClear(_inkTool2);
			_inkTool2.CloseTablet();

			// ポップアップを閉じる
			shomeiUtil.shomeiWindowObj.popup("close");
				
			// 描画用InkToolを初期化
			shomeiInkTool.inkToolClear(_inkTool);
			_inkTool.CloseTablet();

			// ポップアップを閉じる
			paperless.control.hide("inputWindowInkTool");
			shomeiUtil.shomeiWindowObj.popup("close");
		} else {
			alert("署名が未入力です。");
		}
	},

	/**
	 * InkToolをクリアする。
	 * @param inkTool InkToolオブジェクト
	 */
	inkToolClear : function(inkTool) {
		inkTool.ClearInk();
	},

	/**
	 * サインタブレットの接続状態を取得する。
	 * @param inkTool InkToolオブジェクト
	 * @returns {Number} 接続状態のステータスを返す
	 *    -2：サインタブレットドライバの初期化（オープン）に失敗
	 *    -1：サインタブレット未接続
	 *     0：接続機種不明
	 *     1：STU300
	 *     2：STU430
	 */
	isSignPadConnect : function(inkTool) {
		var iRet = 0;
		var openTablet;
		var getSignPadIsConnecting;
		var getSignPadType;

		openTablet = inkTool.OpenTablet();

		if(openTablet !== -1) {
			getSignPadIsConnecting = inkTool.GetSignPadIsConnecting();
			if(getSignPadIsConnecting == 1) {
				getSignPadType = inkTool.GetSignPadType();
				iRet = getSignPadType;
			} else {
				inkTool.CloseTablet();
				iRet = -1;
			}
		}
		else {
			inkTool.CloseTablet();
			iRet = -2;
		}
		return iRet;
	},

	/**
	 * サインタブレットの機種に応じて描画InkToolオブジェクトをリサイズする。
	 */
	inkToolAreaResize : function() {
		var _inkTool = $("#InkTool")[0];	// 描画InkToolオブジェクトを取得

		// 描画InkToolを囲むボーダーの太さを取得
		var borderWidthTop = parseInt($("#inkToolArea").css("border-top-width"));
		var borderWidthLeft = parseInt($("#inkToolArea").css("border-left-width"));

		// オフセットが指定されていればリセット
		if(currentInkToolStatus.addOffset != 0) {
			var defaultOffset = $("#inkToolArea").offset();
			defaultOffset.top += borderWidthTop;
			defaultOffset.left += borderWidthLeft;
			$(_inkTool).offset(defaultOffset);
			currentInkToolStatus.addOffset = 0;
		}

		// InkToolの大きさをリセット
		$("#inkToolArea").removeClass("stu300");
		$("#InkTool").removeClass("stu300");
		$("#inkToolArea").removeClass("stu430");
		$("#InkTool").removeClass("stu430");
		$("#inkToolArea").removeClass("signDisplaySize");
		$("#InkTool").removeClass("signDisplaySize");
		$("#InkTool").removeAttr("width");
		$("#InkTool").removeAttr("height");
		currentInkToolStatus.ratio = 1;

		// サインタブレット種別で処理を分岐
		switch(currentInkToolStatus.signTabletType) {
			case STU300.TYPE :	// STU300の場合
				// 大きさを設定（CSSのクラスで指定）
				$("#inkToolArea").addClass("stu300");
				$("#InkTool").addClass("stu300");
				break;
			case STU430.TYPE : // STU430の場合
				// 大きさを設定（CSSのクラスで指定）
				$("#inkToolArea").addClass("stu430");
				$("#InkTool").addClass("stu430");
				break;
			default:
				break;
		}
		// 倍率を取得
		currentInkToolStatus.ratio = $("#InkTool").width() / defaultX;
	}
};