/*
 * Copyright(C) 2015 SJNKS Corporation, All rights reserved.
 * $Id$
 * @fileoverview shomeiCanvas.js canvasに関する処理を行うJavaScriptファイルです。
 * @author SJNKS 中川
 */
var shomeiCanvas = {
	// クラス内変数
	lastX : 0.0,			// 最後の位置(水平)
	lastY : 0.0,			// 最後の位置(垂直)
	inputFlg : false,		// 署名が入力済みかどうかのフラグ
	startPonitFlg : false, // 描画開始フラグ

	// CanvasData 全面白色
	CANVAS_DATA_WHITE : "",

	// CanvasData 全面透明色
	CANVAS_DATA_TRANSPARENT : "",

	/**
	 * キャンバスの初期化を行う。
	 */
	initCanvas : function () {
		// 全面透明色のbase64文字列を設定
		var base64Str = $("#inputCanvas")[0].toDataURL().replace("data:image/png;base64,", "");
		shomeiCanvas.CANVAS_DATA_TRANSPARENT = base64Str;

		// 署名のクリア処理を実行
		shomeiCanvas.inputCanvasClear();

		// 全面白色のbase64文字列を設定
		base64Str = $("#inputCanvas")[0].toDataURL().replace("data:image/png;base64,", "");
		shomeiCanvas.CANVAS_DATA_WHITE = base64Str;

		// イベントを設定する
		var selectedDevice = shomeiCommon.getDeviceType();
		if (selectedDevice == deviceType.TOUCH_DEVICE) {
			if (currentBrowser == browserType.BROWSER_IE) {
				$("#inputCanvas")[0].addEventListener("pointerdown", shomeiCanvas.startShomei, true);
				$("#inputCanvas")[0].addEventListener("pointermove", shomeiCanvas.drawShomei, true);
				document.addEventListener("pointerup", shomeiCanvas.exitShomei, true);
				document.addEventListener("pointercancel", shomeiCanvas.exitShomei, true);
			} else {
				$("#inputCanvas")[0].addEventListener("touchstart", shomeiCanvas.startShomei, true);
				$("#inputCanvas")[0].addEventListener("touchmove", shomeiCanvas.drawShomei, true);
				document.addEventListener("touchend", shomeiCanvas.exitShomei, true);
				document.addEventListener("touchcancel", shomeiCanvas.exitShomei, true);
			}
		} else if (selectedDevice == deviceType.PEN_TABLET) {
			$("#inputCanvas")[0].addEventListener("mousedown", shomeiCanvas.startShomei, true);
			$("#inputCanvas")[0].addEventListener("mousemove", shomeiCanvas.drawShomei, true);
			document.addEventListener("mouseup", shomeiCanvas.exitShomei, true);
		} else if(selectedDevice == deviceType.MOUSE) {
			$("#inputCanvas")[0].addEventListener("mousedown", shomeiCanvas.startShomei, true);
			document.addEventListener("mouseup", shomeiCanvas.exitShomei, true);
		}
		// canvasウィンドウを表示
		shomeiUtil.shomeiWindowObj.addClass("shomei-window");
		shomeiUtil.shomeiWindowObj.removeClass("device-select-window");
		shomeiUtil.shomeiWindowObj.removeClass("ink-tool300-window");
		shomeiUtil.shomeiWindowObj.removeClass("ink-tool430-window");
		paperless.control.hide("inputWindowInkTool");
		paperless.control.show("inputWindowCanvas");
		paperless.control.hide("inputWindowDevice");
		
		return true;
	},

	/**
	 * 署名開始処理
	 * @param イベントオブジェクト
	 */
	startShomei : function (evt) {
		// イベントオブジェクトを取得
		var ev = null;
		if (currentBrowser == browserType.BROWSER_IE) {
			ev = window.event;
		} else {
			ev = evt;
		}

		//描画開始
		shomeiCanvas.startPonitFlg = true;
		var canvasX = $("#inputCanvas")[0].getBoundingClientRect().left;
		var canvasY = $("#inputCanvas")[0].getBoundingClientRect().top;

		// 最後の描画ポイントには開始位置を設定
		var selectedDevice = shomeiCommon.getDeviceType();
		if (selectedDevice == deviceType.TOUCH_DEVICE) {
			if (currentBrowser == browserType.BROWSER_IE) {
				shomeiCanvas.lastX = (ev.clientX) - canvasX;
				shomeiCanvas.lastY = (ev.clientY) - canvasY;
			} else {
				shomeiCanvas.lastX = (ev.touches[0].clientX) - canvasX;
				shomeiCanvas.lastY = (ev.touches[0].clientY) - canvasY;
			}
		} else if (selectedDevice == deviceType.PEN_TABLET) {
			shomeiCanvas.lastX = (ev.clientX) - canvasX;
			shomeiCanvas.lastY = (ev.clientY) - canvasY;
		} else if(selectedDevice == deviceType.MOUSE) {
			shomeiCanvas.lastX = (ev.clientX) - canvasX;
			shomeiCanvas.lastY = (ev.clientY) - canvasY;
			$("#inputCanvas")[0].addEventListener("mousemove", shomeiCanvas.drawShomei, true);
		}
		// 描画処理を実行
		shomeiCanvas.drawShomei(ev);
	},

	/**
	 * 署名描画処理
	 * @param イベントオブジェクト
	 */
	drawShomei : function (evt) {
		// 描画中でない場合終了
		if (!shomeiCanvas.startPonitFlg){
			return ;
		}

		var pressure = 0.0;		// 筆圧
		var curX = 0.0;			// 現在座標（水平）
		var curY = 0.0;			// 現在座標（垂直）

		// イベントオブジェクトを取得
		var ev = null;
		if (currentBrowser == browserType.BROWSER_IE) {
			ev = window.event;
		} else {
			ev = evt;
		}
		var canvasX = $("#inputCanvas")[0].getBoundingClientRect().left;
		var canvasY = $("#inputCanvas")[0].getBoundingClientRect().top;

		var selectedDevice = shomeiCommon.getDeviceType();
		if (selectedDevice == deviceType.TOUCH_DEVICE) {
			// タッチ操作によるスクロールを抑制
			ev.preventDefault();

			// 筆圧を設定
			pressure = 0.5;

			// 現在座標を取得
			if (currentBrowser == browserType.BROWSER_IE) {
				curX = (ev.clientX) - canvasX;
				curY = (ev.clientY) - canvasY;
			} else {
				curX = (ev.touches[0].clientX) - canvasX;
				curY = (ev.touches[0].clientY) - canvasY;
			}
		} else if (selectedDevice == deviceType.PEN_TABLET) {
			// Webplugin筆圧を取得
			pressure = $("#wtPlugin")[0].penAPI.pressure;

			// 現在座標を取得
			curX = (ev.clientX) - canvasX;
			curY = (ev.clientY) - canvasY;
		} else if (selectedDevice == deviceType.MOUSE) {
			// 筆圧を設定
			pressure = 0.5;

			// 現在座標を取得
			curX = (ev.clientX) - canvasX;
			curY = (ev.clientY) - canvasY;
		}
		// 現在位置が入力canvas内かどうかを判定する
		var capturing = (curX >= 0 && curX <= $("#inputCanvas")[0].clientWidth && curY >= 0 && curY <= $("#inputCanvas")[0].clientHeight);

		if (capturing) {
			if (0.0 < pressure) {
				// 入力ウインドcanvasのサイズと出力用画像サイズの比率を算出
				var ratioX = defaultX / $("#inputCanvas")[0].clientWidth;
				var ratioY = defaultY / $("#inputCanvas")[0].clientHeight;

				// 入力ウインドcanvasのコンテキストオブジェクトを取得
				var ctx = $("#inputCanvas")[0].getContext("2d");
				// 描画を開始する
				ctx.globalAlpha = 1;	// α値
				ctx.beginPath();		// パスをリセット
				// 計算した比率でパス座標を補正
				ctx.moveTo(shomeiCanvas.lastX * ratioX, shomeiCanvas.lastY * ratioY);	// パスに最終座標を指定
				ctx.lineTo(curX * ratioX, curY * ratioY);	// 終端にサブパスを指定
				ctx.lineCap = 'round';						// 線の終端
				ctx.lineWidth = 10.0 * pressure;			// 線の太さ
				ctx.strokeStyle = "rgba(0, 0, 0, 1.0)";		// 線のスタイル
				ctx.stroke();								// パスからサブパスに向かって描画

				// 入力済みフラグを設定
				shomeiCanvas.inputFlg = true;
			}
		}
		// 最終座標を現在の座標に更新
		shomeiCanvas.lastX = curX;
		shomeiCanvas.lastY = curY;
	},

	/**
	 * 署名終了処理
	 */
	exitShomei : function () {
		// 描画終了
		shomeiCanvas.startPonitFlg = false;

		// 署名が入力済みかどうかで分岐する処理を実装
		if (shomeiCanvas.inputFlg) {
			paperless.control.enable("kakutei");
			paperless.control.enable("clear");
		} else {
			paperless.control.disable("kakutei");
			paperless.control.disable("clear");
		}
		if (shomeiCommon.getDeviceType() == deviceType.MOUSE) {
			document.getElementById("inputCanvas").removeEventListener("mousemove", shomeiCanvas.drawShomei, true);
		}
	},

	/**
	 * 入力用ウインドのcanvasをクリアする
	 */
	inputCanvasClear : function () {
		try {
			// canvasの入力をクリア
			var ctx = $("#inputCanvas")[0].getContext("2d");

			// 背景を白で塗りつぶす
			ctx.fillStyle = "White";
			ctx.fillRect(0, 0, defaultX, defaultY);

			// canvasDialogを初期化する
			shomeiCanvas.lastX = 0.0;
			shomeiCanvas.lastY = 0.0;
			shomeiCanvas.inputFlg = false;
			paperless.control.disable("kakutei");
			paperless.control.disable("clear");
		} catch(ex) {
			alert("ClearCanvasEdit() Error: " + ex.message);
		}
	},

	/**
	 * 入力用ウインドの確定ボタンを押下した時の処理
	 */
	inputCanvasOk : function () {
		// base64文字列に出力
		var base64Str = $("#inputCanvas")[0].toDataURL().replace("data:image/png;base64,", "");

		if (base64Str == shomeiCanvas.CANVAS_DATA_WHITE
			|| base64Str == shomeiCanvas.CANVAS_DATA_TRANSPARENT) {

			// 全て白色または透明色の場合エラーとする。
			base64Str = "";
			alert("ご署名を認識できませんでした。再度、ご署名ください。");
			return false;
		}

		shomeiUtil.mainCanvasShomeiDataObj.val(base64Str);

		// 署名画面のcanvasに表示
		shomeiCommon.restore(base64Str);

		// 入力ウインド初期化
		shomeiCanvas.inputCanvasClear();

		// ポップアップを閉じる
		shomeiUtil.shomeiWindowObj.popup("close");

	}
};