/*
 * Copyright (C) 2015 Sompo Japan Nipponkoa Systems, Inc. All Rights Reserved.
 * $Id$
 * @fileoverview menuHelp.js メニュー・ヘルプ画面制御
 * @author SCSK 青池
 */

/*
 * 概要：メニュー画面共通変数です。
 */
var menuHelp = {
	menuHelpObj       : null,
	parent : {
		id : ""
	}
};

/*
 * 概要：メニュー画面共通変数を設定します。
 * @param {object} メニュー・ヘルプオブジェクト
 * @param {boolean} 中断する
 * @param {boolean} 手続きをやめる
 * @param {boolean} 書面での手続きに変更
 */
function initMenuHelp(menuHelpObj) {
	menuHelp.parent.id = $("div:first").attr("id");
	menuHelp.menuHelpObj = menuHelpObj;
}

/*
 * 概要：メニューのポップアップ画面を表示します。
 */
function clickMenuHelp() {
	// メニューのhtmlをロードする
	menuHelp.menuHelpObj.load("GHPCA250.html", function() {
		// 画面項目制御
		controlMenuItems();
		// ポップアップを表示する
		menuHelp.menuHelpObj.popup("open");
	});
}
