/*
 * Copyright(C) 2017 SCSK Corporation, All rights reserved.
 * $Id$
 * @fileoverview hozenPaperlessCommon.js 保全共通関数クラスのJavaScriptファイルです。
 * @author SCSK 苗
 */

//保全手続きモード
var hozenOperationMode = {
	TSUJO		:"1",		// 通常解約
	HOZENDOJI	:"2"		// 保全同時新契約
};
// 保全手続きモードのCookieのキー
var hozenOperationModeKey = "hozenOperationMode";

/*
 * 保全手続きモードをCookieに設定します。
 * 設定先はhozenOperationModeKeyをキー値とするクッキー。有効期限は明日 午前1時（サービス時間は0時までだが、少し余裕を持たせる）。
 * @param  {string} mode 保全手続きモード
 */
function putHozenOperationMode( mode ) {
	var cookiePath = make_PATH();
	var curTime = new Date();
	var endTime = new Date(curTime.getFullYear(), curTime.getMonth(), curTime.getDate() + 1, 1);
	var expireTime = endTime - curTime;
	document.cookie = hozenOperationModeKey + "=" + mode + ";Path=" + cookiePath + ";expire=;" + expireTime;
};

/*
 * 保全手続きモードをCookieから取得します。
 *
 * @return {string} 保全手続きモード
 */
function getHozenOperationMode() {
	return cookie_read(hozenOperationModeKey);
};

/*
 * 保全手続きモードのCookieを削除します。
 */
function deleteHozenOperationMode() {
	var cookiePath = make_PATH();
	var curTime = new Date();
	var expireTime = new Date(curTime.getFullYear(), curTime.getMonth(), curTime.getDate() - 1);
	document.cookie = hozenOperationModeKey + "=;Path=" + cookiePath + ";expire=;" + expireTime.toUTCString();
};