/*
 * @fileoverview GHPCA370.js メール送信確認画面
 * @author SCSK 齋藤
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA371",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA371DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var clientErr = editDisplayElement(appliData["EDIT_ITEMS"]);
		var appData = appliData["IDV_DATA"]; 
		// メッセージ設定処理
		if (getMailsoshinData().fg == "1") {
			$("#message").html("テストメールを送信します。よろしいですか。");
		} else {
			$("#message").html("メールを送信します。よろしいですか。");
		}
	});
});

/* 概要：画面遷移（別HTML）[はい]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_hai", function (ev) {
	if (getMailsoshinData().fg == "1") {
		location.href = "GHPCA370.html";
	} else {
		location.href = "GHPCA380.html";
	}
	//paperless.page.change("clickHai", variable.bean, variable.id);
});

/*
 * 概要：画面遷移（別HTML）[いいえ],[×],[閉じる]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_iie,b_batsu,b_tojiru", function (ev) {
	if (getMailsoshinData().fg == "1") {
		// メール送信フラグ設定処理
		var mailsoshinData = new Object();
		mailsoshinData.fg = "0";
		setMailsoshinData(mailsoshinData);
	}
	location.href = "GHPCA370.html";
	//paperless.page.change("back", variable.bean, variable.id);
});
