/*
 * @fileoverview GHPCA370.js オンライン（お客さま直接入力）用メール送信画面
 * @author SCSK 齋藤
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA370",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA370DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var clientErr = editDisplayElement(appliData["EDIT_ITEMS"]);
		var appData = appliData["IDV_DATA"];
		//var mailsoshindisable = searchIdvDataValue(appData, "mailsoshindisable");
		//if (mailsoshindisable == "1") {
		if (getMailsoshinData().fg == "0" || getMailsoshinData().fg == null) {
			paperless.control.disable("b_mailsoshin");
		} else {
			paperless.control.enable("b_mailsoshin");
		}
		initMenuHelp($("#menuHelpUp"));
		// メールアドレス取得処理
		$("#mailaddressNyuryoku").val(getMailaddressData().nyuryoku);
		$("#mailaddressKakunin").val(getMailaddressData().kakunin);
	});
});

/* 概要：画面遷移（別HTML）[テストメール送信]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_testMailsoshin", function (ev) {
	if(paperless.page.validate(variable.id , makeTankomokuChecks())){
		// メールアドレス設定処理
		var mailaddressData = new Object();
		mailaddressData.nyuryoku = $("#mailaddressNyuryoku").val();
		mailaddressData.kakunin = $("#mailaddressKakunin").val();
		setMailaddressData(mailaddressData);
		// メール送信フラグ設定処理
		var mailsoshinData = new Object();
		mailsoshinData.fg = "1";
		setMailsoshinData(mailsoshinData);
		location.href = "GHPCA371.html";
		//paperless.page.change("clickTestMailsoshin", variable.bean, variable.id);
	};
});

/*
 * 概要：画面遷移（別HTML）[メール送信]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_mailsoshin", function (ev) {
	if(paperless.page.validate(variable.id , makeTankomokuChecks())){
		// メール送信フラグ設定処理
		var mailsoshinData = new Object();
		mailsoshinData.fg = "2";
		setMailsoshinData(mailsoshinData);
		location.href = "GHPCA371.html";
	//paperless.page.change("clickMailsoshin", variable.bean, variable.id);
	};
});

/*
 * 概要：入力値変更時制御
 * @param {string}   イベントID
 * @param {function} 値変更処理
 */
paperless.event.change("mailaddressNyuryoku,mailaddressKakunin", function(ev) {
	var MAIL_SOSHINZUMI_FG_OFF = "0";
	paperless.control.disable("b_mailsoshin");
	$("#testMailSoshinFg").val(MAIL_SOSHINZUMI_FG_OFF);
	// メール送信フラグ設定処理
	var mailsoshinData = new Object();
	mailsoshinData.fg = "0";
	setMailsoshinData(mailsoshinData);
});

/*
 * 概要：単項目チェックで対象にするIDの一覧を作成します。
 * @return {string} 単項目チェックで対象にするIDの一覧
 */
function makeTankomokuChecks() {
	var chks = new Array();
	//if ($("#mailaddressNyuryoku").val() != "") {
		chks.push("mailaddressNyuryoku");
	//}

	//if ($("#mailaddressKakunin").val() != "") {
		chks.push("mailaddressKakunin");
	//}
	return chks.join(",");
}
