/*
 * @fileoverview GHPCA340.js よくあるご質問画面
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA340",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA340DataBean"
};
var overlayGamenIds = new Array();

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
//	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
//		var clientErr = editDisplayElement(appliData["EDIT_ITEMS"]);
//	});
});

/*
* 概要：  [よくあるご質問]リンク押下処理
* @param {string}   リンクID
* @param {function} リンク押下処理
*/
paperless.event.click(null,"[id$=Link]", function (ev) {
	var selGyo = $(this).children("p").text();
	$("[id$='Category']").each(function(){
		var goJun = $(this).text();
		if (selGyo == goJun) {
			// 遷移先を取得
			var offset = $(this).offset().top;
			$('html,body').animate({scrollTop: offset}, 'fast');
			// フォーカスを当てる
			$(this).next().find("a").first().focus();
			return false;
		}
	});
});

/*
* 概要：  [よくあるご質問FAQ]リンク押下処理
* @param {string}   リンクID
* @param {function} リンク押下処理
*/
paperless.event.click(null,"[id*=FAQ]", function (ev) {
	// 画面遷移
	var FAQYogoCd = $(this).parents("li").children("p[id*='FAQYogoCd']").text();
	var gamenId = $(this).parents("li").children("p[id*='GamenId']").text();
	var exDataArray = new Array();
	exDataArray[0] = new Array();
	exDataArray[1] = new Array();
	exDataArray[0][0] = "FAQYogoCd";
	exDataArray[0][1] = FAQYogoCd;
	exDataArray[1][0] = "gamenId";
	exDataArray[1][1] = gamenId;
	if(gamenId == "GHPCA350"){
		paperless.page.change("clickFAQ", variable.bean, variable.id ,exDataArray);
	} else {
		var hasCss = false;
		for (var i = 0; i < overlayGamenIds.length; i++) {
			if (gamenId == overlayGamenIds[i]) {
				hasCss = true;
				break;
			}
		}
		if (!hasCss) {
			$('head').append($('<link rel="stylesheet" href="..\/css\/bus\/' + gamenId + '.css">'));
			overlayGamenIds.push(gamenId);
		}
		paperless.page.overlay(gamenId, gamenId);
	}
});

/*
* 概要：「閉じる」ボタン押下処理
* @param {string}   ボタンID
* @param {function} ボタン押下処理
*/
paperless.event.click("b_tojiru", function (ev) {
	window.close();
});
