/*
 * @fileoverview GHPCA320.js 用語の説明画面
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA320",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA320DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
//	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
//		var clientErr = editDisplayElement(appliData["EDIT_ITEMS"]);
//	});
});

/*
* 概要：[行選択リンク]押下処理
* @param {string}   リンクID
* @param {function} リンク押下処理
*/
paperless.event.click(null,"[id^=l_gyoSEL]", function (ev) {
	var selGyo = $(this).children("p").text();
	selGyo = selGyo.substring(0,1);
	$("[id^='gojuonMidashi']").each(function(){
		var goJun = $(this).text();
		if (selGyo == goJun) {
			// フォーカスを当てる
			var fistLink = $(this).parents("tr").find("a").first();
			fistLink.focus();
			// 遷移先を取得
			var offset = fistLink.offset().top;
			$('html,body').animate({scrollTop: offset}, 'fast');
			return false;
		}
	});
});

/*
 * 概要：変数定義
 */
var overlayGamenIds = new Array();

/*
* 概要：用語リンク押下処理
* @param {string}   リンクID
* @param {function} リンク押下処理
*/
paperless.event.click(null,"[id^=yogoDisplay]", function (ev) {
	// 画面遷移
	var yogoCd = $(this).children("p:first").text();
	var exDataArray = new Array();
	exDataArray[0] = new Array();
	exDataArray[0][0] = "yogoCd";
	exDataArray[0][1] = yogoCd;
	var gamenID = $(this).children("p[id^='gamenID']").text();

	if(gamenID == "GHPCA330"){
		paperless.page.change("clickYogo",variable.bean, variable.id ,exDataArray);
	} else {
		var hasCss = false;
		for (var i = 0; i < overlayGamenIds.length; i++) {
			if (gamenID == overlayGamenIds[i]) {
				hasCss = true;
				break;
			}
		}
		if (!hasCss) {
			$('head').append($('<link rel="stylesheet" href="..\/css\/bus\/' + gamenID + '.css">'));
			overlayGamenIds.push(gamenID);
		}
		paperless.page.overlay(gamenID, gamenID);
	}
});

/*
* 概要：「閉じる」ボタン押下処理
* @param {string}   ボタンID
* @param {function} ボタン押下処理
*/
paperless.event.click("b_tojiru", function (ev) {
	window.close();
});
