/*
 * @fileoverview GHPCA300.js 「中断確認」画面
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variableChudan = {
	id: "GHPCA300",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA300DataBean"
};

/*
 * 概要：初期表示処理
 * 
 * @param {string} 画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variableChudan.id, function() {
	// 初期表示
	paperless.page.load("init", variableChudan.bean, variableChudan.id, function (appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		initMenuHelp($("#menuHelpUp")); 
		// 非対面の場合、メッセージを表示
		if (paperless.util.isHitaimenkb) {
			paperless.control.show("onlineMessage");
		}
	});
});

/*
 * 概要：[手続きを中断しない]ボタン押下処理
 *       [閉じる]ボタン押下処理
 *       [×]ボタン押下
 * @param {string}   リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click("b_tetsuzukiChudanShinai, b_tojiru, b_batsu", function (ev) {
	closeOverlayWithMenu();
});

/*
 * 概要：[手続きを中断する]ボタン押下処理
 * @param {string}   リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click("b_tetsuzukiChudanSuru", function (ev) {
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickTetsuzukiChudanSuru";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA310.html";
//	paperless.page.change("clickTetsuzukiChudanSuru", variableChudan.bean, variableChudan.id);
});