/*
 * @fileoverview GHPCA280.js 「キャンセル確認」画面
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variableCancel = {
	id :"GHPCA280",
	bean :"jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA280DataBean"
};

/*
 * 概要：初期表示処理
 * 
 * @param {string} 画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variableCancel.id, function() {
	// Cookieから保全手続きを取得
	var hozenOperationModeVal = getHozenOperationMode();
	if (hozenOperationModeVal) {
		if (hozenOperationModeVal == hozenOperationMode.TSUJO) {
			$(".tsujoKaiyaku").remove();
		}
	}
});

/*
 * 概要：
 * [手続きをキャンセルしない]ボタン押下処理
 * [閉じる]ボタン押下処理
 * [×]ボタン押下処理
 * 
 * @param {string} リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click("b_tetsuzukiCancelShinai, b_tojiru, b_batsu", function(ev) {
	closeOverlayWithMenu();
});

/*
 * 概要：[手続きをキャンセルする]ボタン押下処理
 * @param {string} リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click("b_tetsuzukiCancelSuru", function(ev) {
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickTetsuzukiCancelSuru";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA290.html";
//	paperless.page.change("clickTetsuzukiCancelSuru", variableCancel.bean, variableCancel.id);
});