/*
 * @fileoverview GHPCA270.js 「書面切り替え完了」画面
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA270",
	bean : "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA270DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		initMenuHelp($("#menuHelpUp"));
		// 非対面の場合、終了するボタンを非表示
		if (paperless.util.isHitaimenkb) {
			paperless.control.hide("b_shuryo");
		}
	});
});

/*
 * 概要：[終了する]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_shuryo", function(ev) {
	window.close();
});