/*
 * @fileoverview GHPCA250.js メニュー・ヘルプ画面
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variableChudan = {
	id :"GHPCA300",
	bean :"jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA300DataBean",
	isSettingScript :false
};
var variableCancel = {
	id :"GHPCA280",
	bean :"jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA280DataBean",
	isSettingScript :false
};
var variableShomen = {
	id :"GHPCA260",
	bean :"jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA260DataBean",
	isSettingScript :false
};

/*
 * 概要：画面遷移（別HTML）[解約手続きを中断する]ボタン押下処理
 * 
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kaiyakuTetsuzukiChudan", function(ev) {
	if (!variableChudan.isSettingScript) {
		$('head').append($('<script src="..\/js\/bus\/' + variableChudan.id + '.js"><\/script>'));
		variableChudan.isSettingScript = true;
	}
	paperless.page.overlay(variableChudan.id, variableChudan.id);
});

/*
 * 概要：画面遷移（別HTML）[解約手続きをキャンセルする]ボタン押下処理
 * 
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kaiyakuTetsuzukiCancel", function(ev) {
	if (!variableCancel.isSettingScript) {
		$('head').append($('<script src="..\/js\/bus\/' + variableCancel.id + '.js"><\/script>'));
		variableCancel.isSettingScript = true;
	}
	paperless.page.overlay(variableCancel.id, variableCancel.id);
});

/*
 * 概要：画面遷移（別HTML） [解約手続きを書面に変更する]ボタン押下処理
 * 
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kaiyakuTetsuzukiShomenHenko",function(ev) {
	if (!variableShomen.isSettingScript) {
		$('head').append($('<script src="..\/js\/bus\/' + variableShomen.id + '.js"><\/script>'));
		variableShomen.isSettingScript = true;
	}
	paperless.page.overlay(variableShomen.id, variableShomen.id);
});

/*
 * 概要：画面遷移（別HTML）[用語説明]リンク押下処理
 * 
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("l_yogosetsumei",function(ev) {
	var transitionData = new Object();
	transitionData.eventId = "yogo";
	transitionData.pageId = menuHelp.parent.id;
	setTransitionData(transitionData);
	window.open(
		"GHPCA320.html",
		"HO_PaperlessHelp",
		"directories=0,location=0,menubar=0,scrollbars=1,status=0,toolbar=0,resizable=1,width=800,height=600");
});

/*
 * 概要：画面遷移（別HTML）[よくあるご質問]リンク押下処理
 * 
 * @param {string} ボタンID
 * @param {function}
 */
paperless.event.click("l_yokuaruShitsumon",function(ev) {
	var transitionData = new Object();
	transitionData.eventId = "goshitsumon";
	transitionData.pageId = menuHelp.parent.id;
	setTransitionData(transitionData);
	window.open(
		"GHPCA340.html",
		"HO_PaperlessHelp",
		"directories=0,location=0,menubar=0,scrollbars=1,status=0,toolbar=0,resizable=1,width=800,height=600");
});

/*
 * 概要：画面遷移（別HTML）[×]ボタンまたは[閉じる]ボタン押下処理
 * 
 * @param {string} ボタンID
 * @param {function}
 */
paperless.event.click("b_tojiruMenu,b_batsuMenu", function(ev) {
	// ポップアップを閉じる
	menuHelp.menuHelpObj.popup("close");
});

/*
 * 概要：メニュー系ボタンの活性・非活性制御
 */
function controlMenuItems() {
	var id = menuHelp.parent.id;
	// 全部非活性
	if (id == "GHPCA010"
		|| id == "GHPCA020"
		|| id == "GHPCA030"
		|| id == "GHPCA050"
		|| id == "GHPCA240"
		|| id == "GHPCA270") {
		// 中断
		disableMenuBtn("b_kaiyakuTetsuzukiChudan");
		// キャンセル
		disableMenuBtn("b_kaiyakuTetsuzukiCancel");
		// 書面手続変更
		disableMenuBtn("b_kaiyakuTetsuzukiShomenHenko");
	}

	// キャンセル以外、非活性
	if (id == "GHPCA380") {
		// 中断
		disableMenuBtn("b_kaiyakuTetsuzukiChudan");
		// 書面手続変更
		disableMenuBtn("b_kaiyakuTetsuzukiShomenHenko");
	}

	// 通常解約の場合、中断のみ非活性
	var hozenOperationModeVal = getHozenOperationMode();
	if (typeof getHozenOperationMode == 'function' && hozenOperationModeVal == hozenOperationMode.TSUJO) {
		if (id == "GHPCA060"
			|| id == "GHPCA080"
			|| id == "GHPCA100"
			|| id == "GHPCA110"
			|| id == "GHPCA120"
			|| id == "GHPCA130"
			|| id == "GHPCA140"
			|| id == "GHPCA150"
			|| id == "GHPCA170"
			|| id == "GHPCA180"
			|| id == "GHPCA210"
			|| id == "GHPCA230"
			|| id == "GHPCA360"
			|| id == "GHPCA370") {
			// 中断
			disableMenuBtn("b_kaiyakuTetsuzukiChudan");
		}
	}

	// 非対面の場合、ヘルプを非表示
	if (paperless.util.isHitaimenkb){
		$("#l_help").hide();
	}
}

/*
 * 概要：メニュー系ボタンを非活性状態にする
 */
function disableMenuBtn(btnId) {
	paperless.control.disable(btnId);
	$("#" + btnId).addClass("ui-disabled-menu");
	$("#" + btnId).removeClass("arrow");
}