/*
 * @fileoverview GHPCA230.js 親権者署名
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA230",
	bean : "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA230DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.control.hide("b_shomeiYarinaosu");
	paperless.control.hide("b_kaiyakuDoi");
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		
		init($("#mainCanvas"), $("#shomeiWindow"), $("#mainCanvasShomeiData"), "shomei-window");
		$("#mainCanvasShomeiData").val("");
		
		initMenuHelp($("#menuHelpUp"));
		
		// 署名画面クローズ後
		$("#shomeiWindow").on("popupafterclose",function(){
			// 署名デバイス・個体識別情報取得
			$("#shomeiDevice").val(getDeviceType());
			$("#kotaiShikibetsuJoho").val(getDeviceInfo());
			if($("#mainCanvasShomeiData").val() != ""){
				paperless.control.show("mainCanvasDisplay");
				paperless.control.hide("b_shomei");
				paperless.control.show("b_shomeiYarinaosu");
				paperless.control.show("b_kaiyakuDoi");
			} else {
				paperless.control.hide("mainCanvasDisplay");
				paperless.control.show("b_shomei");
				paperless.control.hide("b_shomeiYarinaosu");
				paperless.control.hide("b_kaiyakuDoi");
			}
		});
	});
});

/*
 * 概要：画面遷移（別HTML）[署名する]、[署名をやり直す]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_shomei, b_shomeiYarinaosu", function(ev) {
	// 署名画面ポップアップ
	initWindow();
});

/*
 * 概要：画面遷移（別HTML）[解約に同意する]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kaiyakuDoi", function (ev) {
	paperless.page.change("clickKaiyakuDoi", variable.bean, variable.id);
});