/*
 * @fileoverview GHPCA200.js 金融機関検索
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA200",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA200DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	// 初期表示
	paperless.page.load("init", variable.bean, variable.id, function(appliData) {
		// 本来は初期表示処理をサーバへ問い合わせる必要は無いが、editDisplayElementで行う各項目の初期化処理をしたいため、実施。
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		$("#r_kinyukikanShurui1").prop("checked", true);
		$("#r_kinyukikanMeisho1").prop("checked", true);
		$("#r_shitenMeisho1").prop("checked", true);
		paperless.control.refreshAll(variable.id);
	});
});

/*
 * 概要：金融機関名称フォーカスアウト
 * @param {string}   ボタンID
 * @param {function} ラジオボタンを選択された処理
 */
paperless.event.change("t_kinyukikanMeisho", function (ev) {
	if($("#r_kinyukikanMeisho1").is(":checked")){
		$("#t_kinyukikanMeisho").removeClass("tokana").addClass("tokanji");
	} else if($("#r_kinyukikanMeisho2").is(":checked")){
		$("#t_kinyukikanMeisho").removeClass("tokanji").addClass("tokana");
	} else {
		$("#t_kinyukikanMeisho").removeClass("tokana").removeClass("tokanji");
	}
});

/*
 * 概要：支店名称フォーカスアウト
 * @param {string}   ボタンID
 * @param {function} ラジオボタンを選択された処理
 */
paperless.event.change("t_shitenMeisho", function (ev) {
	if($("#r_shitenMeisho1").is(":checked")){
		$("#t_shitenMeisho").removeClass("tokana").addClass("tokanji");
	} else if($("#r_shitenMeisho2").is(":checked")){
		$("#t_shitenMeisho").removeClass("tokanji").addClass("tokana");
	} else {
		$("#t_shitenMeisho").removeClass("tokana").removeClass("tokanji");
	}
});

/*
 * 概要：フォーカスアウト
 * @param {string}   ボタンID
 * @param {function} [金融機関コード]入力欄 フォーカスアウト
 */
paperless.event.change("t_kinyukikanCode", function (ev) {
	if ($("#t_kinyukikanCode").val() != "") {
		$("#t_kinyukikanCode").val(paddingZero($("#t_kinyukikanCode").val(),4));
	}
});

/*
 * 概要：フォーカスアウト
 * @param {string}   ボタンID
 * @param {function} [支店コード]入力欄 フォーカスアウト
 */
paperless.event.change("t_shitenCode", function (ev) {
	if ($("#t_shitenCode").val() != ""){
		$("#t_shitenCode").val(paddingZero($("#t_shitenCode").val(),3));
	}
});

/*
 * 概要：[金融機関名称検索]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kinyukikanKensakuMeisho", function (ev) {
	// 単項目チェックの設定
	var settings = new Array();
	// 単項目チェック対象の一覧
	var chks = new Array();
	// 金融機関名称の入力がある場合
	if ($("#t_kinyukikanMeisho").val() != "") {
		if ($("input[name='kinyukikanMeishoType']:checked").val() == 1) {
			settings.push({ name:"金融機関名称", selector:"#t_kinyukikanMeisho", PatternKanjiSpace:true, maxLength:30 });
		} else {
			settings.push({ name:"金融機関名称", selector:"#t_kinyukikanMeisho", PatternZenkakuEisuKana:true, maxLength:30 });
		}
		chks.push("t_kinyukikanMeisho");
	}
	// 支店名称の入力がある場合
	if ($("#t_shitenMeisho").val() != "") {
		if ($("input[name='shitenMeishoType']:checked").val() == 1) {
			settings.push({ name:"支店名称", selector:"#t_shitenMeisho", PatternKanjiSpace:true, maxLength:30 });
		} else {
			settings.push({ name:"支店名称", selector:"#t_shitenMeisho", PatternZenkakuEisuKana:true, maxLength:30 });
		}
		chks.push("t_shitenMeisho");
	}

	//単項目定義初期化
	paperless.page.validRemove(variable.id);
	//単項目定義設定
	paperless.page.validRegist(variable.id, settings);
	// 単項目チェック
	if(paperless.page.validate(variable.id, chks.join(","))){
		var exDataArray = new Array();
		var counter = 0;
		exDataArray[counter] = new Array();
		exDataArray[counter][0] = "kinyukikanShurui";
		exDataArray[counter][1] = $("input[name='kinyukikanShurui']:checked").val();

		counter = counter + 1;
		exDataArray[counter] = new Array();
		exDataArray[counter][0] = "kinyukikanMeishoType";
		exDataArray[counter][1] = $("input[name='kinyukikanMeishoType']:checked").val();

		counter = counter + 1;
		exDataArray[counter] = new Array();
		if ($("input[name='kinyukikanMeishoType']:checked").val() == 1) {
			exDataArray[counter][0] = "kinyukikanMeisho";
		} else {
			exDataArray[counter][0] = "kinyukikanMeishoKana";
		}
		exDataArray[counter][1] = $("#t_kinyukikanMeisho").val();

		counter = counter + 1;
		exDataArray[counter] = new Array();
		exDataArray[counter][0] = "shitenMeishoType";
		exDataArray[counter][1] = $("input[name='shitenMeishoType']:checked").val();

		counter = counter + 1;
		exDataArray[counter] = new Array();
		if ($("input[name='shitenMeishoType']:checked").val() == 1) {
			exDataArray[counter][0] = "shitenMeisho";
		} else {
			exDataArray[counter][0] = "shitenMeishoKana";
		}
		exDataArray[counter][1] = $("#t_shitenMeisho").val();

		paperless.page.ajax("clickKensakuMeisho", variable.bean, variable.id, exDataArray, function(appliData) {
			var editItems = new Array();
			{
				var editItem = new Array();
				{
					var editRepeat = new Array();
					{
						var patterns = new Array();
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "0009";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "三井住友銀行";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanMeisho'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "025";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "新宿新都心支店";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenMeisho'] = temp;
							}
							patterns[0] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "0009";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "三井住友銀行";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanMeisho'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "221";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "新宿支店";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenMeisho'] = temp;
							}
							patterns[1] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "0009";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "三井住友銀行";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanMeisho'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "259";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "新宿西口支店";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenMeisho'] = temp;
							}
							patterns[2] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "0009";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "三井住友銀行";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanMeisho'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "661";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "新宿通支店";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenMeisho'] = temp;
							}
							patterns[3] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "0009";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "三井住友銀行";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanMeisho'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "840";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "新宿御苑前支店";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenMeisho'] = temp;
							}
							patterns[4] = pattern;
						}
						editRepeat['bankBranchPattern'] = patterns;
					}
					editItem['EDIT_REPEAT'] = editRepeat;
				}
				editItems[0] = editItem;
			}
			{
				var editItem = new Array();
				{
					var editSimple = new Array();
					{
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							editSimple['displaySearchTBL'] = temp;
						}
					}
					editItem['EDIT_SIMPLE'] = editSimple;
				}
				editItems[1] = editItem;
			}
			$("[id^='bankBranchPattern_']").remove();
			// 再検索用にラジオボタン押下時のスクリプトエラー対策のリネームを元のnameに戻し
			$('input[name="newkakunintaisho"]').attr('name','kakunintaisho');
			var clientErr = editDisplayElement(editItems);
			// ラジオボタン押下時のスクリプトエラー対策でリネーム
			$("[id='bankBranchPattern']").find('input[name="kakunintaisho"]').attr('name','newkakunintaisho');
			paperless.control.refreshAll(variable.id);
			paperless.control.disable("b_kakuteiTsugihe");
		});
	}
});

/*
 * 概要：[金融機関（銀行）コード検索]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kinyukikanKensakuCode", function (ev) {
	// 単項目チェックの設定
	var settings = new Array();
	// 単項目チェック対象の一覧
	var chks = new Array();
	// 金融機関コードの入力がある場合
	if ($("#t_kinyukikanCode").val() != "") {
		settings.push({ name:"金融機関コード", selector:"#t_kinyukikanCode", PatternHankakuSujiZeroAri:true, maxLength:4, isDigit:true });
		chks.push("t_kinyukikanCode");
	}
	// 支店コードの入力がある場合
	if ($("#t_shitenCode").val() != "") {
		settings.push({ name:"支店コード", selector:"#t_shitenCode", PatternHankakuSujiZeroAri:true, maxLength:3, isDigit:true });
		chks.push("t_shitenCode");
	}

	//単項目定義初期化
	paperless.page.validRemove(variable.id);
	//単項目定義設定
	paperless.page.validRegist(variable.id, settings);
	// 単項目チェック
	if(paperless.page.validate(variable.id, chks.join(","))){
		var exDataArray = new Array();
		var counter = 0;
		exDataArray[counter] = new Array();
		exDataArray[counter][0] = "ginkouCD";
		exDataArray[counter][1] = $("#t_kinyukikanCode").val();

		counter = counter + 1;
		exDataArray[counter] = new Array();
		exDataArray[counter][0] = "shitenCD";
		exDataArray[counter][1] = $("#t_shitenCode").val();

		paperless.page.ajax("clickKensakuCode", variable.bean, variable.id, exDataArray, function(appliData) {
			var editItems = new Array();
			{
				var editItem = new Array();
				{
					var editRepeat = new Array();
					{
						var patterns = new Array();
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "0009";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "三井住友銀行";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kinyukikanMeisho'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "593";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenCode'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "東京ディズニーランド出張所";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shitenMeisho'] = temp;
							}
							patterns[0] = pattern;
						}
						editRepeat['bankBranchPattern'] = patterns;
					}
					editItem['EDIT_REPEAT'] = editRepeat;
				}
				editItems[0] = editItem;
			}
			{
				var editItem = new Array();
				{
					var editSimple = new Array();
					{
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							editSimple['displaySearchTBL'] = temp;
						}
					}
					editItem['EDIT_SIMPLE'] = editSimple;
				}
				editItems[1] = editItem;
			}
			$("[id^='bankBranchPattern_']").remove();
			// 再検索用にラジオボタン押下時のスクリプトエラー対策のリネームを元のnameに戻し
			$('input[name="newkakunintaisho"]').attr('name','kakunintaisho');
			var clientErr = editDisplayElement(editItems);
			// ラジオボタン押下時のスクリプトエラー対策でリネーム
			$("[id='bankBranchPattern']").find('input[name="kakunintaisho"]').attr('name','newkakunintaisho');
			paperless.control.refreshAll(variable.id);
			paperless.control.disable("b_kakuteiTsugihe");
		});
	}
});

/*
 * 概要：金融機関を選択したとき
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.change(null ,'[name=kakunintaisho]', function (ev) {
	paperless.control.enable("b_kakuteiTsugihe");
});

/*
 * 概要：[確定して次へ]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuteiTsugihe", function (ev) {
	var selectObj = $("input[name='kakunintaisho']:checked").parents('tr');

	var exDataArray = new Array();
	var counter = 0;
	exDataArray[counter] = new Array();
	exDataArray[counter][0] = "kakuteikinyukikanCD";
	exDataArray[counter][1] = selectObj.find('.kakuteikinyukikanCD').text();

	counter = counter + 1;
	exDataArray[counter] = new Array();
	exDataArray[counter][0] = "kakuteishitenCD";
	exDataArray[counter][1] = selectObj.find('.kakuteishitenCD').text();

	counter = counter + 1;
	exDataArray[counter] = new Array();
	exDataArray[counter][0] = "kakuteikinyukikanMeisho";
	exDataArray[counter][1] = selectObj.find('.kakuteikinyukikanMeisho').text();

	counter = counter + 1;
	exDataArray[counter] = new Array();
	exDataArray[counter][0] = "kakuteishitenMeisho";
	exDataArray[counter][1] = selectObj.find('.kakuteishitenMeisho').text();
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakuteiTsugihe";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA180_1.html";
	//paperless.page.change("clickKakuteiTsugihe", variable.bean, variable.id, exDataArray);
});