/*
 * Copyright(C) 2017 SCSK Corporation, All rights reserved.
 * $Id$
 * @fileoverview GHPCA180.js 「解約支払金受取口座指定」画面
 * @author SCSK 小泉
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA180",
	bean : "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA180DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function() {

	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = new Array();
		{
			var editItem = new Array();
			{
				var editRepeat = new Array();
				{
					var patterns = new Array();
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "三井住友銀行";
							temp[1] = 0;
							temp[2] = 0;
							pattern['kikeiyakuKinyukikanmei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "ヒマワリ　ハナコ　さま";
							temp[1] = 0;
							temp[2] = 0;
							pattern['kikeiyakuKozameigininKana'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "新宿西口支店";
							temp[1] = 0;
							temp[2] = 0;
							pattern['kikeiyakuShitenmei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "0011***";
							temp[1] = 0;
							temp[2] = 0;
							pattern['kozabangoOrTsuchobango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "4";
							temp[1] = 0;
							temp[2] = 0;
							pattern['sentakuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "12345-678";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenBango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "普通";
							temp[1] = 0;
							temp[2] = 0;
							pattern['yokinshumokuOrTsuchokigo'] = temp;
						}
						patterns[0] = pattern;
					}
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "三井住友銀行";
							temp[1] = 0;
							temp[2] = 0;
							pattern['kikeiyakuKinyukikanmei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "ヒマワリ　タロウ　さま";
							temp[1] = 0;
							temp[2] = 0;
							pattern['kikeiyakuKozameigininKana'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "東京ディズニーランド出張所";
							temp[1] = 0;
							temp[2] = 0;
							pattern['kikeiyakuShitenmei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "0011***";
							temp[1] = 0;
							temp[2] = 0;
							pattern['kozabangoOrTsuchobango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "4";
							temp[1] = 0;
							temp[2] = 0;
							pattern['sentakuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "23456-789";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenBango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "普通";
							temp[1] = 0;
							temp[2] = 0;
							pattern['yokinshumokuOrTsuchokigo'] = temp;
						}
						patterns[1] = pattern;
					}
					var hozenOperationModeVal = getHozenOperationMode();
					if (hozenOperationModeVal == hozenOperationMode.TSUJO) {
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "三井住友銀行";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kikeiyakuKinyukikanmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "ヒマワリ　タロウ　さま";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kikeiyakuKozameigininKana'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "五反田支店";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kikeiyakuShitenmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "0011***";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kozabangoOrTsuchobango'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "4";
								temp[1] = 0;
								temp[2] = 0;
								pattern['sentakuNo'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "34567-890";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shokenBango'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "当座";
								temp[1] = 0;
								temp[2] = 0;
								pattern['yokinshumokuOrTsuchokigo'] = temp;
							}
							patterns[2] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "三井住友銀行";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kikeiyakuKinyukikanmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "ヒマワリ　タロウ　さま";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kikeiyakuKozameigininKana'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "梅田支店";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kikeiyakuShitenmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "0011***";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kozabangoOrTsuchobango'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "4";
								temp[1] = 0;
								temp[2] = 0;
								pattern['sentakuNo'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "45678-901";
								temp[1] = 0;
								temp[2] = 0;
								pattern['shokenBango'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "その他";
								temp[1] = 0;
								temp[2] = 0;
								pattern['yokinshumokuOrTsuchokigo'] = temp;
							}
							patterns[3] = pattern;
						}
					}
					editRepeat['kikeiyakuKozaPattern'] = patterns;
				}
				editItem['EDIT_REPEAT'] = editRepeat;
			}
			editItems[0] = editItem;
		}
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "※ご契約者さま名義の口座のみご指定できます。";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['chushaku'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['t_kozabango'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['t_yuchoIgaiKozameigininKana'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "三井住友銀行";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['yuchoIgaiKinyukikanmei'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "新宿西口支店";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['yuchoIgaiShitenmei'] = temp;
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[1] = editItem;
		}
		var clientErr = editDisplayElement(editItems);
		initMenuHelp($("#menuHelpUp"));
		// ラジオボタン押下時のスクリプトエラー対策でリネーム
		$("[id='kikeiyakuKozaPattern']").find('input[name="sentaku"]').attr('name','newsentaku');
		var appData = appliData["IDV_DATA"];
		var kozaShitei = "2";
		if (kozaShitei && kozaShitei == "2") {
			$("input[name='kozaShiteiKB']").val([kozaShitei]);
		} else {
			$("input[name='kozaShiteiKB']").val(["1"]);
		}
		var kinyukikan = "";
		if (kinyukikan && kinyukikan == "9900") {
			$("input[name='kinyukikanKB']").val([kinyukikan]);
		} else {
			$("input[name='kinyukikanKB']").val(["0"]);
		}
		var futsuToza = "1";
		if (futsuToza && futsuToza == "2") {
			$("input[name='futsuToza']").val([futsuToza]);
		} else {
			$("input[name='futsuToza']").val(["1"]);
		}
		var selectedShokenNo = searchIdvDataValue(appData, "selectedShokenNo");
		if (selectedShokenNo && selectedShokenNo != "") {
			$(".shokenBango").each(function() {
				if ($(this).text().trim() == selectedShokenNo) {
					$(this).parents('tr').find('input[name=sentaku]').prop("checked",true);
				}
			});
		}
		$(".kikeiyakuKinyukikanmei").each(function(idx, elem) {
			if ($(this).text().trim() == "") {
				$(this).parents("tr").find(".mergeCell").remove();
				$(this).text("口座登録がありません");
				$(this).attr("colSpan", 5);
				$(this).parents('tr').find('td').addClass("disabledAccount");
				$(this).parents('tr').find('input[name=sentaku]').addClass("disabledRadio");
			}
		});
		var disabledAccounts = "23456-789,34567-890,45678-901,";
		if (disabledAccounts && disabledAccounts != "") {
			var disabledAccountList = disabledAccounts.split(",");
			$(".shokenBango").each(function() {
				for (var i = 0; i < disabledAccountList.length; i++) {
					if ($(this).text() == disabledAccountList[i]) {
						$(this).parents('tr').find('td').addClass("disabledAccount");
						$(this).parents('tr').find('input[name=sentaku]').addClass("disabledRadio");
					}
				}
			});
		}
		var disabledKikeiyakuKozaShitei = searchIdvDataValue(appData, "disabledKikeiyakuKozaShitei");
		if (disabledKikeiyakuKozaShitei && disabledKikeiyakuKozaShitei == "1") {
			$("#r_kikeiyakuKozaShitei").addClass("disabledRadio");
		}
		paperless.control.disable(null,".disabledRadio"); 
		if (!$("#r_kikeiyakuKozaShitei").is(":disabled") && $("input[name='sentaku']:checked").length == 0) {
			$("input[name='sentaku']").each(function() {
				if (!$(this).is(":disabled")) {
					$(this).prop("checked",true);
					return false;
				}
			});
		}
		checkKozaShitaiKB();
		changeBtnGo();
	});
});

/*
 * 概要：画面遷移（別HTML）[金融機関検索]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("l_kensaku", function(ev) {
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKensaku";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA200.html";
	//paperless.page.change("clickKensaku", variable.bean, variable.id);
});

/*
 * 概要：画面遷移（別HTML）[確認して次へ(お客さまのご署名)]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuninTsugihe", function(ev) {
	// 単項目チェック実施
	var settings = new Array();
	// 単項目チェック対象の一覧
	var chks = new Array();
	var kozaShiteiKB = $("input[name='kozaShiteiKB']:checked").val();
	if (kozaShiteiKB == "1") {
		var exDataArray = new Array();
		exDataArray[0] = new Array();
		exDataArray[0][0] = "sentakuNo";
		exDataArray[0][1] = $("input[name='sentaku']:checked").parents("tr").find(".sentakuNo").val();
		var transitionData = new Object();
		transitionData.pageId = variable.id;
		transitionData.eventId = "clickKakuninTsugihe";
		var retTransitionData = setTransitionData(transitionData);
		location.href = "GHPCA210.html";
		//paperless.page.change("clickKakuninTsugihe", variable.bean, variable.id, exDataArray);
	} else {
		var kinyukikanKB = $("input[name='kinyukikanKB']:checked").val();
		if (kinyukikanKB == "0") {
			settings.push({ name:"口座番号", selector:"#t_kozabango", PatternHankakuSujiZeroAri:true, maxLength:7, isDigit:true });
			settings.push({ name:"口座名義人（カナ）", selector:"#t_yuchoIgaiKozameigininKana", PatternKozameigininKanaSpace:true, nameFormat:true, maxLength:30 });
			chks.push("t_kozabango");
			chks.push("t_yuchoIgaiKozameigininKana");
		} else {
			settings.push({ name:"通帳記号", selector:"#t_tsuchokigo", PatternHankakuSujiZeroAri:true, maxLength:3, isDigit:true });
			settings.push({ name:"通帳番号", selector:"#t_tsuchobango", PatternHankakuSujiZeroAri:true, maxLength:7, isDigit:true });
			settings.push({ name:"口座名義人（カナ）", selector:"#t_yuchoKozameigininKana", PatternKozameigininKanaSpace:true, nameFormat:true, maxLength:30 });
			chks.push("t_tsuchokigo");
			chks.push("t_tsuchobango");
			chks.push("t_yuchoKozameigininKana");
		}
		//単項目定義初期化
		paperless.page.validRemove(variable.id);
		//単項目定義設定
		paperless.page.validRegist(variable.id, settings);
		// 単項目チェック
		if(paperless.page.validate(variable.id, chks.join(","))){
			var transitionData = new Object();
			transitionData.pageId = variable.id;
			transitionData.eventId = "clickKakuninTsugihe";
			var retTransitionData = setTransitionData(transitionData);
			if (kinyukikanKB == "0") {
				if($("#t_yuchoIgaiKozameigininKana").val() != "ヒマワリ　ハナコ") {
					location.href = "GHPCA190.html";
				} else {
					location.href = "GHPCA210.html";
				}
			}else{
				if ($("#t_yuchoKozameigininKana").val() != "ヒマワリ　ハナコ") {
					location.href = "GHPCA190.html";
				} else {
					location.href = "GHPCA210.html";
				}
			}
			//paperless.page.change("clickKakuninTsugihe", variable.bean, variable.id);
		}
	}
});

/*
 * 概要：口座指定ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.change(null ,'[name=kozaShiteiKB]', function (ev) {
	checkKozaShitaiKB();
	changeBtnGo();
});

/*
 * 概要：金融機関ラジオボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.change(null ,'[name=kinyukikanKB]', function (ev) {
	checkKinyukikanKB();
	changeBtnGo();
});

/*
 * 概要：[口座番号]変更
 * @param {string}   ボタンID
 * @param {function} [口座番号]入力欄 変更時の処理
 */
paperless.event.change("t_kozabango", function (ev) {
	if ($("#t_kozabango").val() != "") {
		$("#t_kozabango").val(paddingZero($("#t_kozabango").val(),7));
	}
	changeBtnGo();
});

/*
 * 概要：[ゆうちょ銀行以外口座名義人（カナ）]変更
 * @param {string}   ボタンID
 * @param {function} [ゆうちょ銀行以外口座名義人（カナ）]入力欄 変更時の処理
 */
paperless.event.change("t_yuchoIgaiKozameigininKana", function (ev) {
	changeBtnGo();
});

/*
 * 概要：[通帳記号]変更
 * @param {string}   ボタンID
 * @param {function} [通帳記号]入力欄 変更時の処理
 */
paperless.event.change("t_tsuchokigo", function (ev) {
	if ($("#t_tsuchokigo").val() != "") {
		$("#t_tsuchokigo").val(paddingZero($("#t_tsuchokigo").val(),3));
	}
	changeBtnGo();
});

/*
 * 概要：[通帳番号]変更
 * @param {string}   ボタンID
 * @param {function} [通帳番号]入力欄 変更時の処理
 */
paperless.event.change("t_tsuchobango", function (ev) {
	if ($("#t_tsuchobango").val() != "") {
		$("#t_tsuchobango").val(paddingZero($("#t_tsuchobango").val(),7));
	}
	changeBtnGo();
});

/*
 * 概要：[ゆうちょ銀行口座名義人（カナ）]変更
 * @param {string}   ボタンID
 * @param {function} [ゆうちょ銀行口座名義人（カナ）]入力欄 フォーカスアウト
 */
paperless.event.change("t_yuchoKozameigininKana", function (ev) {
	changeBtnGo();
});

/*
 * 概要：[既契約の口座を指定する/上記以外の口座を指定する]ラジオボタンの値による制御
 */
function checkKozaShitaiKB() {
	var kozaShiteiKB = $("input[name='kozaShiteiKB']:checked").val();
	if (kozaShiteiKB) {
		if (kozaShiteiKB == "1") {
			paperless.control.hide("newKoza");
			paperless.control.show(null,"input[name=sentaku]");
		} else {
			paperless.control.show("newKoza");
			paperless.control.hide(null,"input[name=sentaku]");
			checkKinyukikanKB();
		}
	}
}

/*
 * 概要：[ゆうちょ銀行以外の金融機関/ゆうちょ銀行]ラジオボタンの値による制御
 */
function checkKinyukikanKB() {
	var kinyukikanKB = $("input[name='kinyukikanKB']:checked").val();
	if (kinyukikanKB) {
		if (kinyukikanKB == "0") {
			paperless.control.show("newKozaYuchoIgai");
			paperless.control.hide("newKozaYucho");
		} else {
			paperless.control.hide("newKozaYuchoIgai");
			paperless.control.show("newKozaYucho");
		}
	}
	paperless.control.refreshAll(variable.id);
}

/*
 * 概要：[確認して次へ]ボタンの活性制御
 */
function changeBtnGo() {
	paperless.control.disable("b_kakuninTsugihe");
	var kozaShiteiKB = $("input[name='kozaShiteiKB']:checked").val();
	var enableBtn = false;
	if (kozaShiteiKB) {
		if (kozaShiteiKB == "1") {
			if ($("input[name='sentaku']").is(":checked")) {
				enableBtn = true;
			}
		} else {
			var kinyukikanKB = $("input[name='kinyukikanKB']:checked").val();
			if (kinyukikanKB) {
				if (kinyukikanKB == "0") {
					if ($("#yuchoIgaiKinyukikanmei").text().trim() != "" && $("#yuchoIgaiShitenmei").text().trim() != "" && $("#t_kozabango").val() != "" && $("#t_yuchoIgaiKozameigininKana").val() != "") {
						enableBtn = true;
					}
				} else {
					if ($("#t_tsuchokigo").val() != "" && $("#t_tsuchobango").val() != "" && $("#t_yuchoKozameigininKana").val() != "") {
						enableBtn = true;
					}
				}
			}
		}
	}
	if (enableBtn) {
		paperless.control.enable("b_kakuninTsugihe");
	}
	paperless.control.refreshAll(variable.id);
}