/*
 * @fileoverview GHPCA150.js 個人情報取扱いについて
 * @author SCSK 苗
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA150",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA150DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	// 初期表示
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var hozenOperationModeVal = getHozenOperationMode();
		var editItems = new Array();
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						if (hozenOperationModeVal == hozenOperationMode.TSUJO) {
							editSimple['doishimasu3'] = temp;
						} else {
							editSimple['doishimasu4'] = temp;
						}
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[0] = editItem;
		}
		var clientErr = editDisplayElement(editItems);
		initMenuHelp($("#menuHelpUp"));
	});
});

/*
 * 概要：画面遷移（別HTML）[同意します]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_doishimasu", function (ev) {
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickDoishimasu";
	var retTransitionData = setTransitionData(transitionData);
	var hozenOperationModeVal = getHozenOperationMode();
	if (hozenOperationModeVal == hozenOperationMode.TSUJO) {
		location.href = "GHPCA170.html";
	} else {
		location.href = "GHPCA160.html";
	}
	//paperless.page.change("clickDoishimasu", variable.bean, variable.id);
});
