/*
 * @fileoverview GHPCA130.js 「解約対象既契約一覧確認」画面
 * @author SCSK 良川
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA130",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA130DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.control.disable("b_kakuninTsugihe");
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = new Array();
		{
			var editItem = new Array();
			{
				var editRepeat = new Array();
				{
					var patterns = new Array();
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['hd_b_kakuninRed'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　太郎　さま";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　花子　さま";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['hd_lineId'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "12345-678：<br>医療保険（０８）Ｂ型６０日型";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_kikeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "211206003413";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_seikyuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "5,000 円";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_shiharaikingaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "123-T4567890：<br>医療保険（２０１４）";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_shinkeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "変換";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_tetsuzukiShurui'] = temp;
						}
						patterns[0] = pattern;
					}
					{
						var pattern = new Array();
						var tbl_count = 1;
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['hd_b_kakuninWhite'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　太郎　さま";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　花子　さま";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['hd_lineId'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "23456-789：<br>無解約返戻金型収入保障保険";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_kikeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "211206003414";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_seikyuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "0 円";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_shiharaikingaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "123-T0987654：<br>無解約返戻金型収入保障保険";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_shinkeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "解約<br>新契約";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_tetsuzukiShurui'] = temp;
						}
						patterns[1] = pattern;
					}
					{
						var pattern = new Array();
						var tbl_count = 2;
						{
							var temp = new Array();
							temp[0] = "－";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_kakuninBtn'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 2;
							temp[2] = 1;
							pattern['hd_hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "－";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "－";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_kikeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "211206003415";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_seikyuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "－";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_shiharaikingaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "123-T1234567：<br>低解約返戻金型終身保険";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_shinkeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "該当<br>しない";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hd_tetsuzukiShurui'] = temp;
						}
						patterns[2] = pattern;
					}
					editRepeat['keiyakuPattern'] = patterns;
				}
				editItem['EDIT_REPEAT'] = editRepeat;
			}
			editItems[0] = editItem;
		}
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['div_notTsujokaiyaku'] = temp;
					}
				}
				{
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['mongon2'] = temp;
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[1] = editItem;
		}
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "（重要事項のご確認）";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['kakuninTsugiheSuffix'] = temp;
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[2] = editItem;
		}
		var clientErr = editDisplayElement(editItems);
		var appData = appliData["IDV_DATA"];

		if (searchIdvDataValue(appData, "kakuninTsugiheFg") == 1) {
			paperless.control.enable("b_kakuninTsugihe");
		}

		var preSeikyuNo = "";
		var preNode;
		var rowSpanNum = 1;
		$(".seikyuNo").each(function(idx, elem) {
			var temp = $(this).val();
			if (temp != "") {
				if (preSeikyuNo == temp) {
					$(this).parents("tr").find(".duplicataAble").remove();
					rowSpanNum++;
				} else {
					if (rowSpanNum > 1) {
						preNode.parents("tr").find(".duplicataAble").attr("rowSpan", rowSpanNum);
						rowSpanNum = 1;
					}
					preSeikyuNo = temp;
					preNode = $(this);
				}
			}
		});
		if (rowSpanNum > 1) {
			preNode.parents("tr").find(".duplicataAble").attr("rowSpan", rowSpanNum);
		}

		// 何故か「display: inline;」が入るので、無理やり消す
		$(".kakuninBtn").each(function(idx, elem) {
			$(this).css("display", "");
		});
		paperless.control.hide("hd_b_kakuninRed");
		paperless.control.hide("hd_b_kakuninWhite");
		$(".hasHaifun").each(function(idx, elem) {
			var target = $(this); 
			var temp = target.text();
			if (temp == "－") {
				if (target.is("div")) {
					target.parents("td").removeClass("displayList_ar").removeClass("displayList_al").addClass("displayList_ac");
				} else {
					target.removeClass("displayList_ar").removeClass("displayList_al").addClass("displayList_ac");
				}
			}
		});

		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：[確認]ボタン押下処理
 * @param {string}   null(ボタンID)
 * @param {string}   クラス名
 * @param {function} ボタン押下処理
 */
paperless.event.click(null, ".kakuninBtn", function (ev) {
	var exDataArray = new Array();

	exDataArray[0] = new Array();
	exDataArray[0][0] = "seikyuNo";
	exDataArray[0][1] = $(this).parents('tr').find('.seikyuNo').val();
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakunin";
	var retTransitionData = setTransitionData(transitionData);
	if ($(this).parents('tr').find('[id^=hd_shiharaikingaku_]').text() == "0 円"){
		location.href = "GHPCA140_1.html";
	}else{
		location.href = "GHPCA140.html";
	}
	//paperless.page.change("clickKakunin", variable.bean, variable.id, exDataArray);
});


/*
 * 概要：[確認して次へ]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuninTsugihe", function (ev) {
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakuninTsugihe";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA150.html";
	//paperless.page.change("clickKakuninTsugihe", variable.bean, variable.id);
});
