/*
 * @fileoverview GHPCA130.js 「解約対象既契約一覧確認」画面
 * @author SCSK 良川
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA130",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA130DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.control.disable("b_kakuninTsugihe");
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = new Array();
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['b_kakuninRed'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　太郎　さま";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['hihokenshaMei1'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　花子　さま";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['keiyakushaMei1'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "12345-678：<br>医療保険（０８）Ｂ型６０日型<br>";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['kikeiyaku1'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['line1'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['lineId1'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "211206002738";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['seikyuNo'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "5,000 円";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['shiharaikingaku1'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　太郎　さま";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['hihokenshaMei2'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　花子　さま";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['keiyakushaMei2'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "23456-789：<br>無解約返戻金型収入保障保険<br>";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['kikeiyaku2'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['line2'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['lineId2'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "0 円";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['shiharaikingaku2'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　太郎　さま";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['hihokenshaMei3'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　花子　さま";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['keiyakushaMei3'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "34567-890：<br>終身保険<br>";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['kikeiyaku3'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['line3'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['lineId3'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "150,000 円";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['shiharaikingaku3'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　太郎　さま";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['hihokenshaMei4'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　花子　さま";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['keiyakushaMei4'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "45678-901：<br>定期保険<br>";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['kikeiyaku4'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['line4'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['lineId4'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "59,000 円";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['shiharaikingaku4'] = temp;
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[0] = editItem;
		}
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['div_tsujokaiyaku'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['mongon1'] = temp;
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[1] = editItem;
		}
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "（個人情報の取扱について）";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['kakuninTsugiheSuffix'] = temp;
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[2] = editItem;
		}
		var clientErr = editDisplayElement(editItems);
		var appData = appliData["IDV_DATA"];

		if (searchIdvDataValue(appData, "kakuninTsugiheFg") == 1) {
			paperless.control.enable("b_kakuninTsugihe");
		}

		var preSeikyuNo = "";
		var preNode;
		var rowSpanNum = 1;
		$(".seikyuNo").each(function(idx, elem) {
			var temp = $(this).val();
			if (temp != "") {
				if (preSeikyuNo == temp) {
					$(this).parents("tr").find(".duplicataAble").remove();
					rowSpanNum++;
				} else {
					if (rowSpanNum > 1) {
						preNode.parents("tr").find(".duplicataAble").attr("rowSpan", rowSpanNum);
						rowSpanNum = 1;
					}
					preSeikyuNo = temp;
					preNode = $(this);
				}
			}
		});
		if (rowSpanNum > 1) {
			preNode.parents("tr").find(".duplicataAble").attr("rowSpan", rowSpanNum);
		}

		// 何故か「display: inline;」が入るので、無理やり消す
		$(".kakuninBtn:visible").each(function(idx, elem) {
			$(this).css("display", "");
		});

		$(".hasHaifun").each(function(idx, elem) {
			var target = $(this); 
			var temp = target.text();
			if (temp == "－") {
				if (target.is("div")) {
					target.parents("td").removeClass("displayList_ar").removeClass("displayList_al").addClass("displayList_ac");
				} else {
					target.removeClass("displayList_ar").removeClass("displayList_al").addClass("displayList_ac");
				}
			}
		});

		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：[確認]ボタン押下処理
 * @param {string}   null(ボタンID)
 * @param {string}   クラス名
 * @param {function} ボタン押下処理
 */
paperless.event.click(null, ".kakuninBtn", function (ev) {
	var exDataArray = new Array();

	exDataArray[0] = new Array();
	exDataArray[0][0] = "seikyuNo";
	exDataArray[0][1] = $(this).parents('tr').find('.seikyuNo').val();

	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakunin";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA140.html";
	//paperless.page.change("clickKakunin", variable.bean, variable.id, exDataArray);
});


/*
 * 概要：[確認して次へ]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuninTsugihe", function (ev) {
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakuninTsugihe";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA150.html";
	//paperless.page.change("clickKakuninTsugihe", variable.bean, variable.id);
});
