/*
 * @fileoverview GHPCA120.js 解約手続きの流れ
 * @author SCSK 苗
*/

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA120",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA120DataBean"
};

/*
 * 概要：進捗ステータス
 */
var progressStatus = {
	skip: 0,
	active: 1
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		var appData = appliData["IDV_DATA"];
		if (parseInt(searchIdvDataValue(appData, "flow3")) == progressStatus.skip) {
			$("#flow_3").removeClass("active");
			$("#flow_3").addClass("skip");
		}
		initMenuHelp($("#menuHelpUp"));
	});
});

/*
 * 概要：
 * 画面遷移（別HTML）[確認して次へ(解約内容のご確認)]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuninTsugihe", function (ev) {	
	var hozenOperationModeVal = getHozenOperationMode();
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakuninTsugihe";
	var retTransitionData = setTransitionData(transitionData);
	if (hozenOperationModeVal == hozenOperationMode.TSUJO) {
		location.href = "GHPCA130.html";
	} else {
		location.href = "GHPCA130_ho.html";
	}
	//paperless.page.change("clickKakuninTsugihe", variable.bean, variable.id);
});