/*
 * @fileoverview GHPCA080.js 「本人確認」画面
 * @author SCSK 赤城
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA080",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA080DataBean"
};

/*
 * 概要：変数定義：利用できる公的確認書類画面
 */
var variableKotekiShorui = {
	id: "GHPCA090",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA090DataBean"
};

/*
 * 概要：変数定義：20歳以上かチェック用
 */
var isOver20 = "";
/*
 * 概要：変数定義：単項目チェックを行わないかチェック用
 */
var isNotTankoumoku = "";

/*
 * 概要：変数定義：本人確認チェックボックス文言用
 */
var honninKakunin = {
	mongon1:"・ご提示いただいた本人確認書類を確認し、ご契約者さまの親権者または後見人で<br>　あることを確認しました。<br>・本人確認書類は本日時点で有効であることを確認しました。",
	mongon2:"・ご提示いただいた本人確認書類と下記「ご契約者さま情報」に記載の内容が<br>　一致していることを確認し、ご契約者本人であることを確認しました。<br>・本人確認書類は本日時点で有効であることを確認しました。"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	// 初期表示
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = new Array();
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['b_kakuninTsugihe'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "昭和63（1988）年5月1日　女性";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['birthday_seibetsu'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['dairiMongon_Check'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['dairiMongon_Keiyaku'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "・ご提示いただいた本人確認書類と下記「ご契約者さま情報」に記載の内容が<br>　一致していることを確認し、ご契約者本人であることを確認しました。<br>・本人確認書類は本日時点で有効であることを確認しました。";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['honninKakunin'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['honninKakuninMongon_Over20'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['keiyakushaInfo'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['kotekiKakuninShorui'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "ヒマワリ　ハナコ";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['nameKana'] = temp;
					}
					{
						var temp = new Array();
						temp[0] = "向日葵　花子";
						temp[1] = 0;
						temp[2] = 0;
						editSimple['nameKanji'] = temp;
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[0] = editItem;
		}
		var clientErr = editDisplayElement(editItems);
		var appData = appliData["IDV_DATA"];
		isOver20 = "1";
		isNotTankoumoku = "";
		paperless.control.disable("b_kakuninTsugihe");
		paperless.control.disable("c_honninKakunin");
		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：[公的確認書類]プルダウン押下
 * @param {string} プルダウンID
 * @param {function} ボタン押下処理
 */
paperless.event.change(null, "#p_kotekiKakuninShorui", function(ev) {
	enableControlsPull();
});

/*
 * 概要：[本人確認]チェックボックス押下
 * @param {string} チェックボックスID
 * @param {function} ボタン押下処理
 */
paperless.event.change(null, "#c_honninKakunin", function(ev) {
	enableControlsCheck();
});

/*
 * 概要：[確認対象者]ラジオボタン押下
 * @param {string} ラジオボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.change(null, "[name=kakunintaisho]", function(ev) {
	enableControlsRadio();
});

/*
 * 概要：画面遷移（別HTML）[確認して次へ]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuninTsugihe", function(ev) {
	var exDataArray = new Array();
	exDataArray[0] = new Array();
	exDataArray[0][0] = "over20Flg";
	exDataArray[0][1] = isOver20;
	exDataArray[1] = new Array();
	exDataArray[1][0] = "notTankoumokuCheckFlg";
	exDataArray[1][1] = isNotTankoumoku;
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakuninTsugihe";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA100.html";
	//paperless.page.change("clickKakuninTsugihe", variable.bean, variable.id, exDataArray);
});

/*
 * 概要：画面遷移（別HTML） [利用できる公的確認書類]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("l_kakuninShorui",function(ev) {
	paperless.page.overlay(variableKotekiShorui.id, variableKotekiShorui.id);
});

/*
 * 概要：[公的確認書類]プルダウンの状態によって、画面の表示状態を制御します。
 */
function enableControlsPull() {
	if($("#p_kotekiKakuninShorui").val() != ""){
		paperless.control.enable("c_honninKakunin");
	} else {
		paperless.control.disable("c_honninKakunin");
		$("#c_honninKakunin").prop("checked", false);
		paperless.control.disable("b_kakuninTsugihe");
		paperless.control.refreshAll(variable.id);
	}
}

/*
 * 概要：[本人確認]チェックボックスの状態によって、画面の表示状態を制御します。
 */
function enableControlsCheck() {
	if($("#c_honninKakunin").is(":checked")){
		paperless.control.enable("b_kakuninTsugihe");
	} else {
		paperless.control.disable("b_kakuninTsugihe");
	}
}

/*
 * 概要：[確認対象者]ラジオボタンの状態によって、ボタンや行の表示状態を制御します。
 */
function enableControlsRadio() {
	paperless.control.disable("c_honninKakunin");
	paperless.control.disable("b_kakuninTsugihe");
	$("#kotekiKakuninShorui select").each(function() {
		this.selectedIndex = 0;
	});
	$("#c_honninKakunin").prop("checked", false);
	paperless.control.refreshAll(variable.id);
	if($("[name=kakunintaisho]").is(":checked")){
		if ($("#r_kakunintaisho1").is(":checked") || $("#r_kakunintaisho2").is(":checked")) {
			paperless.control.show("keiyakushaInfo");
			paperless.control.show("kotekiKakuninShorui");
			paperless.control.show("dairiMongon_Shinken");
			paperless.control.hide("dairiMongon_Keiyaku");
			paperless.control.show("dairiMongon_Check");
			$("#honninKakunin").html(honninKakunin.mongon1);
		} else if ($("#r_kakunintaisho3").is(":checked")) {
			paperless.control.show("keiyakushaInfo");
			paperless.control.show("kotekiKakuninShorui");
			paperless.control.hide("dairiMongon_Shinken");
			paperless.control.show("dairiMongon_Keiyaku");
			paperless.control.show("dairiMongon_Check");
			$("#honninKakunin").html(honninKakunin.mongon2);
		}
	}
}