/*
 * @fileoverview GHPCA070.js 「解約手続きトップ」画面
 * @author SCSK 赤城
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA070",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA070DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	// 初期表示
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：画面遷移（別HTML）[確認して次へ]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuninTsugihe", function(ev) {
	putHozenOperationMode(hozenOperationMode.HOZENDOJI);
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakuninTsugihe";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA040.html";
//	paperless.page.change("clickKakuninTsugihe", variable.bean, variable.id);
});

/*
 * 概要：画面遷移（別HTML） [解約手続きを書面に変更する]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("l_shomenTetsuzuki",function(ev) {
	if (!variableShomen.isSettingScript) {
		$('head').append($('<script src="..\/js\/bus\/' + variableShomen.id + '.js"><\/script>'));
		variableShomen.isSettingScript = true;
	}
	paperless.page.overlay(variableShomen.id, variableShomen.id);
});

