/*
 * @fileoverview GHPCA061.js 「手続き不可エラー確認」画面
 * @author SCSK 赤城
*/

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA061",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA060DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.page.load("init1", variable.bean, variable.id, function (appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		if ($("#guidanceError").is(":visible")) {
			paperless.control.show("b_g_error");
		} else {
			paperless.control.show("b_g_guidance");
		}
		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：画面遷移（別HTML）[解約手続きを書面に変更する]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_shomenKirikae", function (ev) {
	if (!variableShomen.isSettingScript) {
		$('head').append($('<script src="..\/js\/bus\/' + variableShomen.id + '.js"><\/script>'));
		variableShomen.isSettingScript = true;
	}
	paperless.page.overlay(variableShomen.id, variableShomen.id);
});

/*
 * 概要：画面遷移（別HTML）[解約手続きをキャンセルする]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_tetsuzukiCancel1,b_tetsuzukiCancel2", function (ev) {
	if (!variableCancel.isSettingScript) {
		$('head').append($('<script src="..\/js\/bus\/' + variableCancel.id + '.js"><\/script>'));
		variableCancel.isSettingScript = true;
	}
	paperless.page.overlay(variableCancel.id, variableCancel.id);
});