/*
 * @fileoverview GHPCA060.js 「エラー内容確認」画面
 * @author SCSK 赤城
*/

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA060",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA060DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.page.load("init0", variable.bean, variable.id, function (appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		if ($("#guidanceError").is(":visible")) {
			paperless.control.show("b_g_error");
		} else {
			paperless.control.show("b_g_guidance");
		}
		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：画面遷移（別HTML）[確認して次へ]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuninTsugihe", function (ev) {
	paperless.page.change("clickKakuninTsugihe", variable.bean, variable.id);
});

/*
 * 概要：画面遷移（別HTML）[確認して戻る]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kakuninModoru1,b_kakuninModoru2", function (ev) {
	paperless.page.change("clickKakuninModoru", variable.bean, variable.id);
});