/*
 * @fileoverview GHPCA050.js 「保全同時新契約・被保険者名寄せ結果・選択」画面
 * @author SCSK 佐藤
*/

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA050",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA050DataBean"
};

/*
 * 解約新契約かどうかのフラグ
 */
var isKaiyakuShinkeiyaku = false;
/*
 * 解約予約かどうかのフラグ
 */
var isKaiyakuYoyaku = false;

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	enableSentakuBtn();
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = new Array();
		{
			var editItem = new Array();
			{
				var editRepeat = new Array();
				{
					var patterns = new Array();
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "向日葵　太郎";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "医療保険（０８）Ｂ型６０日型";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hokenshurui'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['meishoLine'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　花子";
							temp[1] = 0;
							temp[2] = 0;
							pattern['keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "1";
							temp[1] = 0;
							temp[2] = 0;
							pattern['sentakuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "12345-678";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenbango'] = temp;
						}
						patterns[0] = pattern;
					}
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "向日葵　太郎";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "無解約返戻金型収入保障保険";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hokenshurui'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['meishoLine'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　花子";
							temp[1] = 0;
							temp[2] = 0;
							pattern['keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "1";
							temp[1] = 0;
							temp[2] = 0;
							pattern['sentakuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "23456-789";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenbango'] = temp;
						}
						patterns[1] = pattern;
					}
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "向日葵　太郎";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "終身保険";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hokenshurui'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['meishoLine'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　花子";
							temp[1] = 0;
							temp[2] = 0;
							pattern['keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "1";
							temp[1] = 0;
							temp[2] = 0;
							pattern['sentakuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "34567-890";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenbango'] = temp;
						}
						patterns[2] = pattern;
					}
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "向日葵　太郎";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "定期保険";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hokenshurui'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['meishoLine'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　花子";
							temp[1] = 0;
							temp[2] = 0;
							pattern['keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "1";
							temp[1] = 0;
							temp[2] = 0;
							pattern['sentakuNo'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "45678-901";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenbango'] = temp;
						}
						patterns[3] = pattern;
					}
					editRepeat['keiyakuTable'] = patterns;
				}
				editItem['EDIT_REPEAT'] = editRepeat;
			}
			editItems[0] = editItem;
		}
		{
			var editItem = new Array();
			{
				var editSimple = new Array();
				{
					{
						var temp = new Array();
						temp[0] = "NOCHANGE";
						temp[1] = 1;
						temp[2] = 1;
						editSimple['henkan'] = temp;
					}
				}
				editItem['EDIT_SIMPLE'] = editSimple;
			}
			editItems[1] = editItem;
		}
		var clientErr = editDisplayElement(editItems);
		var isSelectedShokenNo = "12345-678";
		if (isSelectedShokenNo && isSelectedShokenNo != "") {
			var shokenbangoList = isSelectedShokenNo.split(",");
			$(".shokenbango").each(function() {
				for (var i = 0; i < shokenbangoList.length; i++) {
					if ($(this).text() == shokenbangoList[i]) {
						$(this).parents('tr').find('input[name=sentaku]').prop("checked",true);
					}
				}
			});
		}
		$(".hihokenshaMei").each(function(idx, elem) {
			if ($(this).text() == "") {
				$(this).remove();
			}
		});
		enableSentakuBtn();
		paperless.control.refreshAll(variable.id);
		if($("#kaiyakushinkeiyaku").is(":visible")) {
			isKaiyakuShinkeiyaku = true;
		}
		if($("#kaiyakuyoyaku").is(":visible")) {
			isKaiyakuYoyaku = true;
		}
		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：画面遷移（別HTML）[選択する]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_sentakusuru", function (ev) {
	var exDataArray = new Array();
	exDataArray[0] = new Array();
	exDataArray[0][0] = "sentakuNoCsv";
	var sentakuNo = "";
	$("input[name='sentaku']:checked").each(function(idx, elem) {
		sentakuNo += $(this).parents("tr").find(".sentakuNo").val() + ",";
	});
	exDataArray[0][1] = sentakuNo;
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickShusei";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA040.html";
	paperless.page.change("clickSentakuSuru", variable.bean, variable.id, exDataArray);
});

/*
 * 概要：[選択]チェックボックス押下処理
 * @param {string} 自ID 
 * @param {string} セレクタ
 * @param {function} 実施処理
 */ 
paperless.event.change(null, "[name=sentaku]", function(ev) {
	if (!isKaiyakuShinkeiyaku && !isKaiyakuYoyaku) {
		if ($(this).is(":checked")) {
			$("[name=sentaku]").prop("checked", false);
			$(this).prop("checked", true);
		}
	}
	enableSentakuBtn();
	paperless.control.refreshAll(variable.id);
});

/*
 * 概要：[選択する]ボタンの活性制御
 */
function enableSentakuBtn() {
	paperless.control.disable("b_sentakusuru");
	$("[name=sentaku]").each(function(idx, elem) {
		if ($(this).is(":checked")) {
			paperless.control.enable("b_sentakusuru");
		}
	});
}
/*
 * 概要：画面遷移（別HTML） [確認]リンク押下処理
 * @param {string} リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click("l_kakunin", function(ev) {
	clickKakunin($(this).parents('tr').find('[id^=shokenbango_]').text());
});
