/*
 * @fileoverview GHPCA040.js 「既契約詳細確認」画面
 * @author SCSK 佐藤
*/

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA040",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA040DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = new Array();
		{
			var editItem = new Array();
			{
				var editRepeat = new Array();
				{
					var patterns = new Array();
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "123-T4567890：<br>医療保険（２０１４）";
							temp[1] = 1;
							temp[2] = 1;
							pattern['aratanahokenkeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['gaitosuruLink'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['gaitosuruShusei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　太郎";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "医療保険（０８）Ｂ型６０日型";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hokenshurui'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　花子";
							temp[1] = 0;
							temp[2] = 0;
							pattern['keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['l_shosaikakunin'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "211206003413";
							temp[1] = 0;
							temp[2] = 0;
							pattern['seikyubango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "12345-678";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenbango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['shusei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "変換";
							temp[1] = 0;
							temp[2] = 0;
							pattern['tetsuzukiShurui'] = temp;
						}
						patterns[0] = pattern;
					}
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "123-T0987654：<br>無解約返戻金型収入保障保険";
							temp[1] = 1;
							temp[2] = 1;
							pattern['aratanahokenkeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['gaitosuruLink'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['gaitosuruShusei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　太郎";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "無解約返戻金型収入保障保険";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hokenshurui'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "向日葵　花子";
							temp[1] = 0;
							temp[2] = 0;
							pattern['keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['l_shosaikakunin'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "211206003414";
							temp[1] = 0;
							temp[2] = 0;
							pattern['seikyubango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "23456-789";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenbango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['shusei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "解約新契約";
							temp[1] = 0;
							temp[2] = 0;
							pattern['tetsuzukiShurui'] = temp;
						}
						patterns[1] = pattern;
					}
					{
						var pattern = new Array();
						var tbl_count = 0;
						{
							var temp = new Array();
							temp[0] = "123-T1234567：<br>低解約返戻金型終身保険";
							temp[1] = 1;
							temp[2] = 1;
							pattern['aratanahokenkeiyaku'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['gaitoshinaiLink'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							pattern['gaitoshinaiShusei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 2;
							temp[2] = 1;
							pattern['hihokenshaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 2;
							temp[2] = 1;
							pattern['keihiLine'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "－";
							temp[1] = 0;
							temp[2] = 0;
							pattern['hokenshurui'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "－";
							temp[1] = 0;
							temp[2] = 0;
							pattern['keiyakushaMei'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "211206003414";
							temp[1] = 0;
							temp[2] = 0;
							pattern['seikyubango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "－";
							temp[1] = 0;
							temp[2] = 0;
							pattern['shokenbango'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "該当しない";
							temp[1] = 0;
							temp[2] = 0;
							pattern['tetsuzukiShurui'] = temp;
						}
						patterns[2] = pattern;
					}
					editRepeat['kikeiyakuIchiranTbl'] = patterns;
				}
				editItem['EDIT_REPEAT'] = editRepeat;
			}
			editItems[0] = editItem;
		}
		var clientErr = editDisplayElement(editItems);
		var appData = appliData["IDV_DATA"];
		var rowSpan = searchIdvDataValue(appData, "rowSpan");
		var rowSpan_kaiyakuYoyaku = searchIdvDataValue(appData, "rowSpan_kaiyakuYoyaku");
		($("[name='shokenNo']").map(function(){
			if(rowSpan != "" && $(this).parents('tr').find('[id^=tetsuzukiShurui_]').text() == "解約新契約"){
				$(this).parents('tr').find('[id^=tetsuzukiShurui_]').attr("rowSpan", Number(rowSpan));
				$(this).parents("tr").find('[id^=aratanahokenkeiyaku_]').attr("rowSpan", Number(rowSpan));
				$(this).parents("tr").find('[id^=shusei]').attr("rowSpan", Number(rowSpan));
			}
			if(rowSpan_kaiyakuYoyaku != "" && $(this).parents('tr').find('[id^=tetsuzukiShurui_]').text() == "解約予約"){
				$(this).parents('tr').find('[id^=tetsuzukiShurui_]').attr("rowSpan", Number(rowSpan_kaiyakuYoyaku));
				$(this).parents("tr").find('[id^=aratanahokenkeiyaku_]').attr("rowSpan", Number(rowSpan_kaiyakuYoyaku));
				$(this).parents("tr").find('[id^=shusei]').attr("rowSpan", Number(rowSpan_kaiyakuYoyaku));
			}
			if($(this).parents('tr').find('[id^=tetsuzukiShurui_]').text() == "該当しない"){
				$(this).parents('tr').find('[id^=hokenshurui_]').removeClass("al").addClass("ac");
			}
		}));
		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：画面遷移（別HTML）[解約手続きを始める]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_kaiyakuHajimeru", function (ev) {
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKaiyakuHajimeru";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA360.html";
	//paperless.page.change("clickKaiyakuHajimeru", variable.bean, variable.id);
});

/*
 * 概要：画面遷移（別HTML）[修正]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_shusei", function (ev) {
	var exDataArray = new Array();
	exDataArray[0] = new Array();
	exDataArray[0][0] = "seikyubango";
	exDataArray[0][1] = $(this).parents('tr').find('[id^=seikyubango_]').val();
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickShusei";
	var retTransitionData = setTransitionData(transitionData);
	if ($(this).parents('tr').find('[id^=shokenbango_]').text() == "12345-678"){
		location.href = "GHPCA050.html";
	}else{
		location.href = "GHPCA050_1.html";
	}
	//paperless.page.change("clickShusei", variable.bean, variable.id, exDataArray);
});

/*
 * 概要：画面遷移（別HTML） [確認]リンク押下処理
 * @param {string} リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click(null, "[id^=l_shosaikakunin]", function(ev) {
	clickKakunin($(this).parents('tr').find('[id^=shokenbango_]').text());
});