/*
 * @fileoverview GHPCA031.js 「お客さま操作中確認」画面
 * @author SCSK 石井(幸)
 */

/*
 * 概要：変数定義
 */
var variableOkyakusamaSousachu = {
	id: "GHPCA031",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA030DataBean"
};

/*
 * 概要：初期表示処理
 * 
 * @param {string} 画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variableOkyakusamaSousachu.id, function() {
});

/*
 * 概要：[確認して戻る]ボタン・[閉じる]ボタン・[×]ボタン押下処理
 * @param {string}   リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click("b_modoru, b_tojiru, b_batsu", function (ev) {
	closeOverlayWithMenu();
});

/*
 * 概要：[確認して次へ]ボタン押下処理
 * @param {string}   リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click("b_kakuninTsugihe", function (ev) {
	var exDataArray = new Array();
	exDataArray[0] = new Array();
	exDataArray[0][0] = "ankenNo";
	exDataArray[0][1] = $("input[name='sentaku']:checked").parents('tr').find('[id^=ankenNo_]').val();
	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKakuninTsugihe";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA040.html";
	paperless.page.change("clickKakuninTsugihe", variableOkyakusamaSousachu.bean, variableOkyakusamaSousachu.id, exDataArray);
});