/*
 * @fileoverview GHPCA030.js 「保全同時新契約　既契約検索」画面
 * @author SCSK 赤城
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA030",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA030DataBean"
};

var variableSosaChu = {
	id: "GHPCA031",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA030DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string}   画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function () {
	// 初期表示
	// 本来は初期表示処理をサーバへ問い合わせる必要は無いが、editDisplayElementで行う各項目の初期化処理をしたいため、実施。
	paperless.page.load("init", variable.bean, variable.id, function(appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
	});
	initMenuHelp($("#menuHelpUp")); 
});

/*
 * 概要：[検索]ボタン押下処理
 * @param {string} 画面ID 
 * @param {function} 初期表示処理
 */
paperless.event.click("b_kensaku", function(ev) {
	$("[id^='moshikomiJohoTbl_']").remove();
	$("[id^='kaiyakuJohoTbl_']").remove();
	paperless.control.hide("kaishimachiList");
	paperless.control.hide("kanryoTorikeshiKirikaeList");
	paperless.control.hide("b_sentakuTsugihe");
	paperless.control.disable("b_sentakuTsugihe");
	// 単項目チェック
	if (paperless.page.validate(variable.id, "t_hihokensha")) {
		paperless.page.ajax("clickKensaku", variable.bean, variable.id, function(appliData) {
			var editItems = new Array();
			{
				var editItem = new Array();
				{
					var editRepeat = new Array();
					{
						var patterns = new Array();
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "1805250147";
								temp[1] = 0;
								temp[2] = 0;
								pattern['ankenNo'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "1";
								temp[1] = 0;
								temp[2] = 0;
								pattern['okyakusamaSousaChu'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "0";
								temp[1] = 1;
								temp[2] = 1;
								pattern['c_sentaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 2;
								temp[2] = 1;
								pattern['hihokenshameimoshikomi'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 2;
								temp[2] = 1;
								pattern['keihiLineMoshikomi'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎（操作中）";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakushameimoshikomi'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2022.02.07 13:09";
								temp[1] = 0;
								temp[2] = 0;
								pattern['koushindate'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "公山　料友";
								temp[1] = 0;
								temp[2] = 0;
								pattern['moshikomiBoshuninmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "解約手続き<br>開始待ち";
								temp[1] = 0;
								temp[2] = 0;
								pattern['tetsuzukiJyokyomoshikomi'] = temp;
							}
							patterns[0] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "1805250147";
								temp[1] = 0;
								temp[2] = 0;
								pattern['ankenNo'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "0";
								temp[1] = 0;
								temp[2] = 0;
								pattern['okyakusamaSousaChu'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "0";
								temp[1] = 1;
								temp[2] = 1;
								pattern['c_sentaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 2;
								temp[2] = 1;
								pattern['hihokenshameimoshikomi'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 2;
								temp[2] = 1;
								pattern['keihiLineMoshikomi'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakushameimoshikomi'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2018.07.12 12:09";
								temp[1] = 0;
								temp[2] = 0;
								pattern['koushindate'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "公山　料友";
								temp[1] = 0;
								temp[2] = 0;
								pattern['moshikomiBoshuninmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "解約手続き<br>開始待ち";
								temp[1] = 0;
								temp[2] = 0;
								pattern['tetsuzukiJyokyomoshikomi'] = temp;
							}
							patterns[1] = pattern;
						}
						editRepeat['moshikomiJohoTbl'] = patterns;
					}
					editItem['EDIT_REPEAT'] = editRepeat;
				}
				editItems[0] = editItem;
			}
			{
				var editItem = new Array();
				{
					var editRepeat = new Array();
					{
						var patterns = new Array();
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 2;
								temp[2] = 1;
								pattern['hihokenshameiKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "公山　料友";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kaiyakuBoshuninmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 2;
								temp[2] = 1;
								pattern['keihiLineKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakusyameiKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2018.07.13  9:40";
								temp[1] = 0;
								temp[2] = 0;
								pattern['saishukoushindate'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2018年08月12日";
								temp[1] = 0;
								temp[2] = 0;
								pattern['sanshokigen'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "12345-678<br />23456-789<br />34567-890<br />45678-901";
								temp[1] = 1;
								temp[2] = 1;
								pattern['shokenbango'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "キャンセル";
								temp[1] = 0;
								temp[2] = 0;
								pattern['tetsuzukiJyokyoKaiyaku'] = temp;
							}
							patterns[0] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hihokenshameiKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "公山　料友";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kaiyakuBoshuninmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　花子";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakusyameiKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2018.07.15 10:40";
								temp[1] = 0;
								temp[2] = 0;
								pattern['saishukoushindate'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2018年08月14日";
								temp[1] = 0;
								temp[2] = 0;
								pattern['sanshokigen'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "ｲ3750149000-1<br />ｲ3750149000-2<br />ｲ3750149000-3<br />ｲ3750149000-4";
								temp[1] = 1;
								temp[2] = 1;
								pattern['shokenbango'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "書面切替";
								temp[1] = 0;
								temp[2] = 0;
								pattern['tetsuzukiJyokyoKaiyaku'] = temp;
							}
							patterns[1] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hihokenshameiKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "公山　料友";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kaiyakuBoshuninmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　次郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakusyameiKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2018.07.16 13:40";
								temp[1] = 0;
								temp[2] = 0;
								pattern['saishukoushindate'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2018年11月13日";
								temp[1] = 0;
								temp[2] = 0;
								pattern['sanshokigen'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "C2480-683<br />C2480-691<br />C2480-709<br />C2480-717<br />C2480-725";
								temp[1] = 1;
								temp[2] = 1;
								pattern['shokenbango'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "完了";
								temp[1] = 0;
								temp[2] = 0;
								pattern['tetsuzukiJyokyoKaiyaku'] = temp;
							}
							patterns[2] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hihokenshameiKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "公山　料友";
								temp[1] = 0;
								temp[2] = 0;
								pattern['kaiyakuBoshuninmei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　三郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakusyameiKaiyaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2022.02.07 15:40";
								temp[1] = 0;
								temp[2] = 0;
								pattern['saishukoushindate'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "2022年06月07日";
								temp[1] = 0;
								temp[2] = 0;
								pattern['sanshokigen'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "C1234-567<br />C1234-568<br />C1234-569";
								temp[1] = 1;
								temp[2] = 1;
								pattern['shokenbango'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "完了<br>オンライン";
								temp[1] = 0;
								temp[2] = 0;
								pattern['tetsuzukiJyokyoKaiyaku'] = temp;
							}
							patterns[3] = pattern;
						}
						editRepeat['kaiyakuJohoTbl'] = patterns;
					}
					editItem['EDIT_REPEAT'] = editRepeat;
				}
				editItems[1] = editItem;
			}
			{
				var editItem = new Array();
				{
					var editSimple = new Array();
					{
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 2;
							temp[2] = 1;
							editSimple['gaitonashi1'] = temp;
						}
					}
					{
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 2;
							temp[2] = 1;
							editSimple['gaitonashi2'] = temp;
						}
					}
					if ($("#c_kaishimachi").is(":checked")){
						{
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 1;
								temp[2] = 1;
								editSimple['kaishimachiDisplay'] = temp;
							}
						}
						{
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 1;
								temp[2] = 1;
								editSimple['kaishimachiList'] = temp;
							}
						}
						{
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 1;
								temp[2] = 1;
								editSimple['moshikomiJohoTitle'] = temp;
							}
						}
					}
					if ($("#c_kanryoTorikeshiKirikae").is(":checked")){
						{
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 1;
								temp[2] = 1;
								editSimple['kaiyakuJohoTitle'] = temp;
							}
						}
						{
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 1;
								temp[2] = 1;
								editSimple['kanryoTorikeshiKirikaeDisplay'] = temp;
							}
						}
						{
							{
								var temp = new Array();
								temp[0] = "NOCHANGE";
								temp[1] = 1;
								temp[2] = 1;
								editSimple['kanryoTorikeshiKirikaeList'] = temp;
							}
						}
					}
					editItem['EDIT_SIMPLE'] = editSimple;
				}
				editItems[2] = editItem;
			}
			var clientErr = editDisplayElement(editItems);
			if($("[id^='moshikomiJohoTbl_']").is(":visible")){
				paperless.control.show("b_sentakuTsugihe");
			}
			paperless.control.refreshAll(variable.id);
		});
	};
});

/*
 * 概要：[選択]チェックボックス押下処理
 * @param {string} 自ID 
 * @param {string} セレクタ
 * @param {function} 実施処理
 */ 
paperless.event.change(null, "[name=sentaku]", function(ev) {
	paperless.control.disable("b_sentakuTsugihe");
	if ($(this).is(":checked")){
		$("[name=sentaku]").prop("checked", false);
		$(this).prop("checked", true);
		paperless.control.enable("b_sentakuTsugihe");
	}
	paperless.control.refreshAll(variable.id);
});

/*
 * 概要：[選択して次へ]ボタン押下処理
 * @param {string} ボタンID 
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_sentakuTsugihe", function(ev) {
	
	var sousaCHuFG = $("input[name='sentaku']:checked").parents('tr').find('[id^=okyakusamaSousaChu_]').val();
	if (sousaCHuFG == '1') {
		paperless.page.overlay(variableSosaChu.id, variableSosaChu.id);
	} else {
		var exDataArray = new Array();
		exDataArray[0] = new Array();
		exDataArray[0][0] = "ankenNo";
		exDataArray[0][1] = $("input[name='sentaku']:checked").parents('tr').find('[id^=ankenNo_]').val();
		var transitionData = new Object();
		transitionData.pageId = variable.id;
		transitionData.eventId = "clickKakuninTsugihe";
		var retTransitionData = setTransitionData(transitionData);
		location.href = "GHPCA040.html";
		paperless.page.change("clickSentakuTsugihe", variable.bean, variable.id, exDataArray);
	}
});
