/*
 * Copyright(C) 2017 SCSK Corporation, All rights reserved.
 * $Id$
 * @fileoverview GHPCA020.js 「通常解約　既契約検索」画面
 * @author SCSK 赤城
 */

/*
 * 概要：変数定義
 */
var variable = {
	id: "GHPCA020",
	bean: "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA020DataBean"
};

/*
 * 概要：変数定義：生年月日チェックを行うか判定用
 */
var birthdayCheck = "";
/*
 * 概要：初期表示処理
 * @param {string} 画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function() {
	// 初期表示
	paperless.page.load("init", variable.bean, variable.id, function (appliData) {
		var editItems = appliData["EDIT_ITEMS"];
		var clientErr = editDisplayElement(editItems);
		var appData = appliData["IDV_DATA"];
		var kensakujokenstr = searchIdvDataValue(appData, "kensakujoken");
		var shokenbangoList = new Array();
		if (kensakujokenstr != ""){
			paperless.control.disable("b_kaiyakuHajimeru");
			paperless.control.hide("b_kaiyakuHajimeru");
			$("input[name='kensakujoken']").val([kensakujokenstr]);
			if (kensakujokenstr == "3"){
				var keiyakuseibetsustr = searchIdvDataValue(appData, "keiyakuseibetsu");
				var p_keiyakugengostr = searchIdvDataValue(appData, "p_keiyakugengo");
				$("input[name='keiyakuseibetsu']").val([keiyakuseibetsustr]);
				$("#p_keiyakugengo").val(p_keiyakugengostr);
			}
			if (kensakujokenstr == "4"){
				var hihokenseibetsustr = searchIdvDataValue(appData, "hihokenseibetsu");
				var p_hihokengengostr = searchIdvDataValue(appData, "p_hihokengengo");
				$("input[name='hihokenseibetsu']").val([hihokenseibetsustr]);
				$("#p_hihokengengo").val(p_hihokengengostr);
			}
			var sentakuShokenbangostr = searchIdvDataValue(appData, "sentakuShokenbango");
			shokenbangoList = sentakuShokenbangostr.split(",");
			($("input[name='sentaku']").map(function(){
				for(var i=0; i<shokenbangoList.length; i++){
					if($(this).parents('tr').find('[id^=shokenbango_]').text() == shokenbangoList[i]){
						$(this).prop("checked",true);
					}
				}
			}));
			if($("[id^='kikeiyakuIchiranTbl_']").is(":visible")){
				paperless.control.show("b_kaiyakuHajimeru");
				if ($("input[name='sentaku']:checked").length > 0) {
					paperless.control.enable("b_kaiyakuHajimeru");
				}
			}
			paperless.control.refreshAll(variable.id);
		}
		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：[検索条件]ラジオボタン押下
 * @param {string} ラジオボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.change(null, "[name=kensakujoken]", function(ev) {
	paperless.control.hide("shokenbango_Area");
	paperless.control.hide("t_shokenbangoHL_Area");
	paperless.control.hide("t_shokenbangoNKL_Area");
	paperless.control.hide("keiyakusha_Area");
	paperless.control.hide("hihokensha_Area");
	paperless.control.hide("kensaku");
	if($("[name=kensakujoken]").is(":checked")){
		paperless.control.show("kensaku");
		if ($("#r_shokenbangoHL").is(":checked")){
			paperless.control.show("shokenbango_Area");
			paperless.control.show("t_shokenbangoHL_Area");
		} else if ($("#r_shokenbangoNKL").is(":checked")){
			paperless.control.show("shokenbango_Area");
			paperless.control.show("t_shokenbangoNKL_Area");
		} else if ($("#r_keiyakushaMei").is(":checked")){
			paperless.control.show("keiyakusha_Area");
		} else if ($("#r_hihokenshaMei").is(":checked")){
			paperless.control.show("hihokensha_Area");
		}
	}
	paperless.control.refreshAll(variable.id);
});

/*
 * 概要：[検索]ボタン押下処理 
 * @param {string} 画面ID 
 * @param {function} 初期表示処理
 */
paperless.event.click("b_kensaku", function(ev) {
	$("[id^='kikeiyakuIchiranTbl_']").remove();
	paperless.control.hide("separator");
	paperless.control.hide("resultDisplay");
	paperless.control.hide("b_kaiyakuHajimeru");
	paperless.control.disable("b_kaiyakuHajimeru");
	if (paperless.page.validate(variable.id, getHisuItem())) {
		var exDataArray = new Array();
		exDataArray[0] = new Array();
		exDataArray[0][0] = "birthdayCheck";
		exDataArray[0][1] = birthdayCheck;
		var shokenbangoHL = $("input[id='t_shokenbangoHL']").val();
		if ($("#r_shokenbangoHL").is(":checked")) {
			paperless.control.disable("t_shokenbangoHL");
			exDataArray[1] = new Array();
			exDataArray[1][0] = "shokenbangoHL";
			exDataArray[1][1] = hankakuToZenkakuKana(shokenbangoHL);
		}
		var shokenbangoNKL = $("input[id='t_shokenbangoNKL']").val();
		if ($("#r_shokenbangoNKL").is(":checked")) {
			paperless.control.disable("t_shokenbangoNKL");
			exDataArray[1] = new Array();
			exDataArray[1][0] = "shokenbangoNKL";
			exDataArray[1][1] = hankakuToZenkakuKana(shokenbangoNKL);
		}
		paperless.control.disable("b_kaiyakuHajimeru");
		paperless.page.ajax("clickKensaku", variable.bean, variable.id, exDataArray, function(appliData) {
			var editItems = new Array();
			{
				var editItem = new Array();
				{
					var editRepeat = new Array();
					{
						var patterns = new Array();
						{
							var pattern = new Array();
							var tbl_count = 0;
							{
								var temp = new Array();
								temp[0] = "0";
								temp[1] = 1;
								temp[2] = 1;
								pattern['c_sentaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hihokenshaMei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "医療保険（０８）Ｂ型６０日型";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hokenshurui'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　花子";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakushaMei'] = temp;
							}
							{
								var temp = new Array();
								if ($("#r_shokenbangoNKL").is(":checked")){
									temp[0] = "ｲ3750149000-1";
								} else {
									temp[0] = "12345-678";
								}
								temp[1] = 0;
								temp[2] = 0;
								pattern['shokenbango'] = temp;
							}
							patterns[0] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 1;
							{
								var temp = new Array();
								temp[0] = "0";
								temp[1] = 1;
								temp[2] = 1;
								pattern['c_sentaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hihokenshaMei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "無解約返戻金型収入保障保険";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hokenshurui'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　花子";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakushaMei'] = temp;
							}
							{
								var temp = new Array();
								if ($("#r_shokenbangoNKL").is(":checked")){
									temp[0] = "ｲ3750149000-2";
								} else {
									temp[0] = "23456-789";
								}
								temp[1] = 0;
								temp[2] = 0;
								pattern['shokenbango'] = temp;
							}
							patterns[1] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 2;
							{
								var temp = new Array();
								temp[0] = "0";
								temp[1] = 1;
								temp[2] = 1;
								pattern['c_sentaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hihokenshaMei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "終身保険";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hokenshurui'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　花子";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakushaMei'] = temp;
							}
							{
								var temp = new Array();
								if ($("#r_shokenbangoNKL").is(":checked")){
									temp[0] = "ｲ3750149000-3";
								} else {
									temp[0] = "34567-890";
								}
								temp[1] = 0;
								temp[2] = 0;
								pattern['shokenbango'] = temp;
							}
							patterns[2] = pattern;
						}
						{
							var pattern = new Array();
							var tbl_count = 3;
							{
								var temp = new Array();
								temp[0] = "0";
								temp[1] = 1;
								temp[2] = 1;
								pattern['c_sentaku'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　太郎";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hihokenshaMei'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "定期保険";
								temp[1] = 0;
								temp[2] = 0;
								pattern['hokenshurui'] = temp;
							}
							{
								var temp = new Array();
								temp[0] = "向日葵　花子";
								temp[1] = 0;
								temp[2] = 0;
								pattern['keiyakushaMei'] = temp;
							}
							{
								var temp = new Array();
								if ($("#r_shokenbangoNKL").is(":checked")){
									temp[0] = "ｲ3750149000-4";
								} else {
									temp[0] = "45678-901";
								}
								temp[1] = 0;
								temp[2] = 0;
								pattern['shokenbango'] = temp;
							}
							patterns[3] = pattern;
						}
						editRepeat['kikeiyakuIchiranTbl'] = patterns;
					}
					editItem['EDIT_REPEAT'] = editRepeat;
				}
				editItems[0] = editItem;
			}
			{
				var editItem = new Array();
				{
					var editSimple = new Array();
					{
						{
							var temp = new Array();
							if ($("#r_shokenbangoHL").is(":checked")){
								temp[0] = "検索条件:証券番号(HL)";
							} else if ($("#r_shokenbangoNKL").is(":checked")){
								temp[0] = "検索条件:証券番号(旧NKL)";
							} else if ($("#r_keiyakushaMei").is(":checked")){
								temp[0] = "検索条件:契約者名";
							} else if ($("#r_hihokenshaMei").is(":checked")){
								temp[0] = "検索条件:被保険者名";
							}
							temp[1] = 0;
							temp[2] = 0;
							editSimple['disp_kensaku_joken'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 2;
							temp[2] = 1;
							editSimple['gaitonashi'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							editSimple['kensakuresult'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							editSimple['kikeiyakuIchiranTitle'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							editSimple['resultDisplay'] = temp;
						}
						{
							var temp = new Array();
							temp[0] = "NOCHANGE";
							temp[1] = 1;
							temp[2] = 1;
							editSimple['separator'] = temp;
						}
					}
					editItem['EDIT_SIMPLE'] = editSimple;
				}
				editItems[1] = editItem;
			}

			var clientErr = editDisplayElement(editItems);
			if ($("#r_shokenbangoHL").is(":checked")) {
				paperless.control.enable("t_shokenbangoHL");
			}
			$("#t_shokenbangoHL").val(shokenbangoHL);
			if ($("#r_shokenbangoNKL").is(":checked")) {
				paperless.control.enable("t_shokenbangoNKL");
			}
			$("#t_shokenbangoNKL").val(shokenbangoNKL);
			if($("[id^='kikeiyakuIchiranTbl_']").is(":visible")){
				paperless.control.show("b_kaiyakuHajimeru");
			}
			paperless.control.refreshAll(variable.id);
		});
	};
});

/* 
 * 概要：必須チェック項目のリストを取得する処理 
 * @return 必須チェック項目のリスト

 */
function getHisuItem() {
	// 単項目チェック実施
	var settings = new Array();
	var check_item = new Array();
	birthdayCheck = "";
	if ($("#r_shokenbangoHL").is(":checked")) {
		settings.push({name:"証券番号", selector:"#t_shokenbangoHL", maxLength:9});
		check_item.push("t_shokenbangoHL");
	} else if ($("#r_shokenbangoNKL").is(":checked")) {
		settings.push({name:"証券番号", selector:"#t_shokenbangoNKL", maxLength:13});
		check_item.push("t_shokenbangoNKL");
	} else if ($("#r_keiyakushaMei").is(":checked")) {
		settings.push({name:"氏名", selector:"#t_keiyakuname", PatternAll:true, maxLength:30});
		check_item.push("t_keiyakuname");
		if($("#p_keiyakugengo").val() != "" || $("#t_keiyakuyear").val() != "" 
			|| $("#t_keiyakumonth").val() != "" || $("#t_keiyakuday").val() != "") {
			settings.push({name:"元号", selector:"#p_keiyakugengo"});
			settings.push({name:"年", selector:"#t_keiyakuyear", PatternHankakuSujiZeroAri:true, maxLength:2, isDigit:true});
			settings.push({name:"月", selector:"#t_keiyakumonth", PatternHankakuSujiZeroAri:true, maxLength:2, isDigit:true});
			settings.push({name:"日", selector:"#t_keiyakuday", PatternHankakuSujiZeroAri:true, maxLength:2, isDigit:true});
			check_item.push("p_keiyakugengo");
			check_item.push("t_keiyakuyear");
			check_item.push("t_keiyakumonth");
			check_item.push("t_keiyakuday");
			birthdayCheck = $("input[name='kensakujoken']:checked").val();
		}
	} else if ($("#r_hihokenshaMei").is(":checked")){
		settings.push({name:"氏名", selector:"#t_hihokenname", PatternAll:true, maxLength:30});
		check_item.push("t_hihokenname");
		if($("#p_hihokengengo").val() != "" || $("#t_hihokenyear").val() != "" 
			|| $("#t_hihokenmonth").val() != "" || $("#t_hihokenday").val() != "") {
			settings.push({name:"元号", selector:"#p_hihokengengo"});
			settings.push({name:"年", selector:"#t_hihokenyear", PatternHankakuSujiZeroAri:true, maxLength:2, isDigit:true});
			settings.push({name:"月", selector:"#t_hihokenmonth", PatternHankakuSujiZeroAri:true, maxLength:2, isDigit:true});
			settings.push({name:"日", selector:"#t_hihokenday", PatternHankakuSujiZeroAri:true, maxLength:2, isDigit:true});
			check_item.push("p_hihokengengo");
			check_item.push("t_hihokenyear");
			check_item.push("t_hihokenmonth");
			check_item.push("t_hihokenday");
			birthdayCheck = $("input[name='kensakujoken']:checked").val();
		}
	}
	//単項目定義初期化
	paperless.page.validRemove(variable.id);
	//単項目定義設定
	paperless.page.validRegist(variable.id, settings);
	return check_item.join(",");
}

/*
 * 概要：[解約手続きを始める]ボタン押下処理 
 * @param {string} 画面ID 
 * @param {function} 初期表示処理
 */
paperless.event.click("b_kaiyakuHajimeru", function(ev) {

	var exDataArray = new Array();
	exDataArray[0] = new Array();
	var shokenbangoList = new Array();
	($("input[name='sentaku']:checked").map(function(){
		shokenbangoList.push(hankakuToZenkakuKana($(this).parents('tr').find('[id^=shokenbango_]').text()));
	}));
	exDataArray[0][0] = "sentakuShokenbango";
	exDataArray[0][1] = shokenbangoList.join(",");

	var shokenbangoHL = $("input[id='t_shokenbangoHL']").val();
	var shokenbangoNKL = $("input[id='t_shokenbangoNKL']").val();

	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickKaiyakuHajimeru";
	var retTransitionData = setTransitionData(transitionData);
	location.href = "GHPCA360.html";

//	paperless.page.change("clickKaiyakuHajimeru", variable.bean, variable.id, exDataArray);

	$("#t_shokenbangoHL").val(shokenbangoHL);
	$("#t_shokenbangoNKL").val(shokenbangoNKL);
});

/*
 * 概要：[選択]チェックボックス押下処理
 * @param {string} 自ID 
 * @param {string} セレクタ
 * @param {function} 実施処理
 */ 
paperless.event.change(null, "[name=sentaku]", function(ev) {
	paperless.control.disable("b_kaiyakuHajimeru");
	if ($("input[name='sentaku']:checked").length > 0) {
		paperless.control.enable("b_kaiyakuHajimeru");
	}
	paperless.control.refreshAll(variable.id);
});

/*
 * 概要：[証券番号(HL)]フォーカスアウト
 * @param {string}   ボタンID
 * @param {function} [証券番号(HL)]入力欄 フォーカスアウト
 */
paperless.event.change("t_shokenbangoHL", function (ev) {
	var enhyphen = RegExp("[\\-]");
	var strhyphen = "-";
	if (($(this).val().replace(enhyphen,"")).indexOf(strhyphen) == -1) {
		var format = RegExp("[0-9A-Za-z]{1}[0-9]{7}");
		var str = ($(this).val().replace(/\s+/g, "")).replace(enhyphen, "");
		var padZero = paddingZero(str, 8);
		var position = 3;
		if ($(this).val().indexOf(strhyphen) != -1){
			position = str.length - ($(this).val().replace(/\s+/g, "")).indexOf(strhyphen);
		}
		if ($(this).val() != "" && str.length > 3 && str.length < 9 && padZero.match(format) && padZero != "00000000" && position == 3){
			var hyphen = padZero.slice(0, 5) + strhyphen + padZero.slice(5, padZero.length);
			$(this).val(hyphen.toUpperCase());
		}
	}
});

/*
 * 概要：[証券番号(旧NKL)]フォーカスアウト
 * @param {string}   ボタンID
 * @param {function} [[証券番号(旧NKL)]入力欄 フォーカスアウト
 */
paperless.event.change("t_shokenbangoNKL", function (ev) {
	var emhyphen = RegExp("[\\－]");
	if ($(this).val() != "") {
		$(this).val($(this).val().replace(/\s+/g,""));
		$(this).val($(this).val().replace(emhyphen,"-"));
		$(this).val(zenkakuToHankakuKanaShokenNKL($(this).val()));
		$(this).val(toHankakuAlphabet($(this).val()));
		$(this).val($(this).val().toUpperCase());
	}
});

/*
 * 概要：[氏名]フォーカスアウト
 * @param {string}   ボタンID
 * @param {function} [氏名]入力欄 フォーカスアウト
 */
paperless.event.change("t_keiyakuname,t_hihokenname", function (ev) {
	if ($(this).val() != "") {
		$(this).val($(this).val().replace(/^\s+/,""));
	}
});

/*
 * 概要：画面遷移（別HTML） [確認]リンク押下処理
 * @param {string} リンクID
 * @param {function} リンク押下処理
 */
paperless.event.click("l_kakunin", function(ev) {
	clickKakunin($(this).parents('tr').find('[id^=shokenbango_]').text());
});
