/*
 * @fileoverview GHPCA010.js 「ペーパーレス保全手続き選択」画面
 * @author SCSK 笹倉
 */

/*
 * 概要：変数定義
 */
var variable = {
	id : "GHPCA010",
	bean : "jp.co.nksjhimawari.ho.hozen.pl.cancel.bus.databean.GHPCA010DataBean"
};

/*
 * 概要：初期表示処理
 * @param {string} 画面ID
 * @param {function} 初期表示処理
 */
paperless.event.start(variable.id, function() {
	// Cookieから保全手続きを取得
	var hozenOperationModeVal = getHozenOperationMode();
	paperless.control.disable("b_sentakuTsugihe");
	// 初期表示
	paperless.page.load("init", variable.bean, variable.id, function(appliData) {
		// 画面編集用データを取得します。
		var editItems = appliData["EDIT_ITEMS"];
		// 単一・繰り返し項目編集実行
		var clientErr = editDisplayElement(editItems);
		if (hozenOperationModeVal) {
			if (hozenOperationModeVal == hozenOperationMode.TSUJO) {
				// 解約手続きをチェックする
				$("#r_sentaku1").attr("checked", true);
			} else {
				// 保全同時新契約手続きをチェックする
				$("#r_sentaku2").attr("checked", true);
			}
			//[選択して次へ]ボタンの活性非活性を制御
			enableControls();
		}
		//上記以上の場合アンチェック
		initMenuHelp($("#menuHelpUp")); 
	});
});

/*
 * 概要：[選択型商品の提案]ラジオボタン押下
 * @param {string} ラジオボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.change(null, "[name=sentaku]", function(ev) {
	enableControls();
});

/*
 * 概要：画面遷移（別HTML）[選択して次へ]ボタン押下処理
 * @param {string} ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_sentakuTsugihe", function(ev) {
	putHozenOperationMode($("[name=sentaku]:checked").val());

	var transitionData = new Object();
	transitionData.pageId = variable.id;
	transitionData.eventId = "clickSentakuTsugihe";
	var retTransitionData = setTransitionData(transitionData);
	if ($("#r_sentaku1").is(":checked")) {
		location.href = "GHPCA020.html";
	} else if ($("#r_sentaku2").is(":checked")) {
		location.href = "GHPCA030.html";
	}

//	paperless.page.change("clickSentakuTsugihe", variable.bean, variable.id);
});

/*
 * 概要：画面遷移（別HTML）[終了する]ボタン押下処理
 * @param {string}   ボタンID
 * @param {function} ボタン押下処理
 */
paperless.event.click("b_shuryo1,b_shuryo2", function (ev) {
	window.close();
});

/*
 * 概要：チェックボックスの状態によって、ボタンや行の表示状態を制御します。
 */
function enableControls() {
	paperless.control.enable("b_sentakuTsugihe");
}