//****************************************************************************//
//
//  システム名称      ：代理店システム構造改革フェーズⅡ
//  JavaScript名称    ：クライアント基盤JavaScript
//  JavaScriptＩＤ    ：clientBase.js
//  作成者            ：
//  作成日            ：
//------------------------------------------------------------------------------
//  修正履歴          ：
//------------------------------------------------------------------------------
//****************************************************************************//

/********************************
 * クライアント基盤・定義データ
 ********************************/
var cbDefines = {
	appCashMessage :
		'<h3 class="caution-text mb40 fs-16 ml90 appcache-errpop-msg" >' +
		'<BR><BR>コンテンツ情報のダウンロードが、正しく行われませんでした。<br>' +
			'再度、ダウンロードを実行しますか。<br>' +
			'&nbsp;ダウンロードを実施する場合は、' +
			'&nbsp;<span class="appcache-errpop-cnt-or-em">' +
			'「再実行する」</span>&nbsp;を、<br>' +
			'&nbsp;ダウンロードを中止する場合は、' +
			'&nbsp;<span class="appcache-errpop-cnt-or-em">' +
			'「中止する」</span>&nbsp;を<br>' +
			'&nbsp;選択して下さい。<br><br>' +
			'&nbsp;※通信環境が良い場所で実行ください。' +
		'</h3>'
};

/****************
 * 共通情報設定
 ****************/
function setCommonData(commondata) {

	var strName = 'agtCommonData';
	var strValdata = '';
	var strPath = '';

	var setDay = new Date();

	if (commondata == null) {
		return 1;
	}

	if (commondata.sessionId === undefined || commondata.userId === undefined) {
		return 1;
	}

	if (Object.getOwnPropertyNames(commondata).length > 2) {
		return 1;
	}

	if (commondata.sessionId == null || commondata.userId == null) {
		return 1;
	}

	if (typeof (commondata.sessionId) != 'string'
			|| typeof (commondata.userId) != 'string') {
		return 1;
	}

	if ((commondata.sessionId).trim() == "" || (commondata.userId).trim() == "") {
		return 1;
	}

	if (navigator.cookieEnabled == false) {
		return 2;
	}
	strValdata = JSON.stringify(commondata);

	strPath = make_PATH();

	document.cookie = strName + '=' + encodeURIComponent(strValdata) + ';Path='
			+ strPath + ';';

	return 0;
}

/****************
 * 共通情報取得
 ****************/
function getCommonData() {

	try {

		var name = 'agtCommonData'; // クッキーの名前

		var cookie_value = cookie_read(name);

		if (cookie_value == null) {
			return null;
		} else {

			var commondata = JSON.parse(cookie_value);

			if (commondata.sessionId === undefined || commondata.userId === undefined) {
				return null;
			}

			if (Object.getOwnPropertyNames(commondata).length > 2) {
				return null;
			}

			return commondata;
		}
	} catch (e) {
		return null;
	}
}

/**********************
 * 遷移元画面情報設定
 **********************/
function setTransitionData(transitionData) {

	var strName = 'agtTransitionData';
	var strValdata = '';
	var strPath = '';

	var setDay = new Date();

	if (transitionData == null) {
		return 1;
	}

	if (transitionData.pageId === undefined
			|| transitionData.eventId === undefined) {
		return 1;
	}

	if (Object.getOwnPropertyNames(transitionData).length > 2) {
		return 1;
	}

	if (navigator.cookieEnabled == false) {
		return 2;
	}

	if (transitionData.pageId == null || transitionData.eventId == null) {
		var transitionData_cookie = getTransitionData();
		if (transitionData_cookie == null) {
			return 3;
		} else {
			if (transitionData.pageId == null) {
				var pageId_cookie = transitionData_cookie.pageId;
				if (pageId_cookie == null) {
					return 3;
				} else {
					transitionData.pageId = transitionData_cookie.pageId;
				}
			}
			if (transitionData.eventId == null) {
				var eventId_cookie = transitionData_cookie.eventId;
				if (eventId_cookie == null) {
					return 3;
				} else {
					transitionData.eventId = transitionData_cookie.eventId;
				}
			}
		}
	}

	if (typeof (transitionData.pageId) != 'string'
			|| typeof (transitionData.eventId) != 'string') {
		return 1;
	}

	strValdata = JSON.stringify(transitionData);


	strPath = make_PATH();

	document.cookie = strName + '=' + encodeURIComponent(strValdata) + ';Path='
			+ strPath + ';';

	return 0;
}

/**********************
 * 遷移元画面情報取得
 **********************/
function getTransitionData() {

	try {
		var name = 'agtTransitionData'; // クッキーの名前

		var cookie_value = cookie_read(name);

		if (cookie_value == null) {
			return null;
		} else {

			var transitionData = JSON.parse(cookie_value);

			if (transitionData.pageId === undefined || transitionData.eventId === undefined) {
				return null;
			}

			if (Object.getOwnPropertyNames(transitionData).length > 2) {
				return null;
			}

			return transitionData;
		}
	} catch (e) {
		return null;
	}

}

/**************************
 * cookie読み込みメソッド
 **************************/
function cookie_read(cookieName) {

	var cookieString = document.cookie;
	// 発行したクッキーの取得（読み込み）
	if (document.cookie) {
		var cookies = document.cookie.split('; ');
		for (var i = 0; i < cookies.length; i++) {
			var str = cookies[i].split('=');
			if (str[0] == cookieName) {
				return decodeURIComponent(str[1]);
			}
		}
	}
	return null;
}

/********************
 * PATH生成メソッド
 ********************/
function make_PATH() {

	var pathname = location.pathname.split('/');
	var strPath = '';

	if (location.pathname.indexOf('himawariha') == -1
			&& location.pathname.indexOf('himawarilifeha') == -1) {
		strPath = '/';
	} else {
		for (var i = 1; i < pathname.length; i++) {

			strPath = strPath + '/' + pathname[i];
			if (pathname[i].indexOf('himawariha') == -1
					&& pathname[i].indexOf('himawarilifeha') == -1) {
				// 見つからない場合は何もしない
			} else {
				strPath = strPath + '/';
				// 見つかった場合はループを抜ける。
				break;
			}
		}
	}
	return strPath;
}

/****************************
 * トランザクションＩＤ設定
 ****************************/
function setTranData() {

	var strName = 'agtTranID';
	var strValdata = '';
	var strPath = '';

	var setDay = new Date();

	var userId = '';
	var tranId = '';

	if (navigator.cookieEnabled == false) {
		return 2;
	}

	if (getCommonData() == null) {
		return 1;
	} else {
		userId = getCommonData().userId;
	}

	if (userId == null) {
		return 1;
	}

	var daytime = make_YYYYMMDDhhmmss();

	tranId = userId + '-' + daytime;

	strValdata = '{\"tranId\":\"' + tranId + '\"}';

	strPath = make_PATH();

	document.cookie = strName + '=' + encodeURIComponent(strValdata) + ';Path=' + strPath + ';';

	return 0;
}


/******************************
 * YYYYMMDDhhmmss生成メソッド
 ******************************/
function make_YYYYMMDDhhmmss() {
	var getDay = new Date();
	var strYYYY = new String(getDay.getFullYear());
	var strMM = new String(getDay.getMonth() + 1);
	var strDD = new String(getDay.getDate());
	var strhh = new String(getDay.getHours());
	var strminutes = new String(getDay.getMinutes());
	var strss = new String(getDay.getSeconds());

	if (strMM.length < 2) {
		strMM = '0' + strMM;
	}

	if (strDD.length < 2) {
		strDD = '0' + strDD;
	}

	if (strhh.length < 2) {
		strhh = '0' + strhh;
	}

	if (strminutes.length < 2) {
		strminutes = '0' + strminutes;
	}

	if (strss.length < 2) {
		strss = '0' + strss;
	}

	return strYYYY + strMM + strDD + strhh + strminutes + strss;

}

/****************************
 * トランザクションＩＤ取得
 ****************************/
function getTranData() {

	try {

		var name = 'agtTranID'; // クッキーの名前

		var cookie_value = cookie_read(name);

		if (cookie_value == null) {
			return null;
		} else {

			var trandata = JSON.parse(cookie_value);

			if (trandata.tranId === undefined) {
				return null;
			}

			if (Object.getOwnPropertyNames(trandata).length > 1) {
				return null;
			}

			return trandata;
		}
	} catch (e) {
		return null;
	}
}


/**************************
 * 単一・繰り返し項目編集
 **************************/
function editDisplayElement(editItems) {

	var elmtErrData;
	var idx;

	elmtErrData = [];

	for (idx = 0; idx < editItems.length; idx++) {
		if (editItems[idx]['EDIT_SIMPLE'] !== undefined) {
			setSimpleData($('body'), editItems[idx]['EDIT_SIMPLE'], '', elmtErrData);
			continue;
		} else if (editItems[idx]['EDIT_REPEAT'] !== undefined) {
			setRepeatData($('body'), editItems[idx]['EDIT_REPEAT'], '', elmtErrData);
			continue;
		} else {
		}
	}

	// トリム設定(画面表示項目が生成されたのちに実施)
	$('input[type="text"]').on("change" , function(){
		if (!$(this).hasClass("noTrim")) {
			$(this).val($.trim($(this).val()));
		}
	});
	$('input[type="tel"]').on("change" , function(){
		$(this).val($.trim($(this).val()));
	});
	$('textarea').on("change" , function(){
		$(this).val($.trim($(this).val()));
	});

	if (elmtErrData.length > 0) {
		return makeCBErrData('2', 'editDisplayErr', elmtErrData);
	} else {
		return makeCBErrData('0', '', elmtErrData);
	}
}


/****************
 * 単一項目編集
 ****************/
function setSimpleData(parentNode, editSimple, refStr, elmtErrData) {
	var propertyName;
	var nodes;

	for (propertyName in editSimple) {
		nodes = parentNode.find('*[name="' + propertyName + '"], #'+ propertyName);

		if (nodes.length !== 0) {
			nodes.each(function() {
				var returnCode;

				returnCode = 0;

				returnCode = setElementValue(this, editSimple[propertyName]);

				if (returnCode !== '0') {
					elmtErrData.push([ returnCode, propertyName ]);
				} else {
					if ($(this).attr('name') === propertyName) {
						$(this).attr({
							name : propertyName + refStr
						});
					} else {
					}
					if ($(this).attr('id') === propertyName) {
						$(this).attr({
							id : propertyName + refStr
						});
					} else {
					}
				}
			});
		} else {
			elmtErrData.push([ '10', propertyName ]);
		}
	}
}

/**********************
 * 単一項目データ設定
 **********************/
function setElementValue(htmlObj, setVal){
	var selExFlag;
	var selVals;
	var values;
	var visible;
	var abled;
	var idx;

	selVals = [];
	values = [];
	visible = [];
	abled = [];

	if(htmlObj.tagName.toLowerCase() === 'select'){
		for(idx=0; idx<setVal.length-2; idx++){
			values.push(setVal[idx]);
		}
		visible.push(setVal[setVal.length-2]);
		abled.push(setVal[setVal.length-1]);

	}else{
		for(idx=0; idx<setVal.length; idx+=3){
			values.push(setVal[idx]);
			visible.push(setVal[idx+1]);
			abled.push(setVal[idx+2]);
		}
	}

	if(typeof(values[0]) === 'string'){
		switch(htmlObj.tagName.toLowerCase()){
		case 'input' :
			switch($(htmlObj).attr('type').toLowerCase()){
			case 'checkbox' :
				for(idx=0; idx<values.length; idx++){
					if(htmlObj.value === values[idx]){
						setVisibleAbled(htmlObj, visible[idx], abled[idx]);
					}else{
					}
				}
				$(htmlObj).val(values);
				break;

			case 'radio' :
				if(values.length !== 1){
					return '13';
				}else{
				}
				setVisibleAbled(htmlObj, visible[0], abled[0]);
				$(htmlObj).val(values);
				break;

			case 'button' :
				if(values.length !== 1){
					return '13';
				}else{
				}
				setVisibleAbled(htmlObj, visible[0], abled[0]);
				$(htmlObj).attr({btneventid : values[0]});
				break;

			case 'text' :
			case 'hidden' :
			case 'password' :
			default:
				if(values.length !== 1){
					return '13';
				}else{
				}
				setVisibleAbled(htmlObj, visible[0], abled[0]);
				$(htmlObj).val(values[0]);
				break;
			}
			break;

		case 'textarea' :
			if(values.length !== 1){
				return '13';
			}else{
			}
			setVisibleAbled(htmlObj, visible[0], abled[0]);
			$(htmlObj).val(values[0]);
			break;

		case 'select' :
			return '11';

		case 'p' :
		case 'span' :
		case 'td' :
		default :
			if(values.length !== 1){
				return '13';
			}else{
			}
			setVisibleAbled(htmlObj, visible[0], abled[0]);
			if(values[0] === 'NOCHANGE'){
			}else{
				$(htmlObj).html(values[0]);
			}
			break;
		}
	}else{
		if(htmlObj.tagName.toLowerCase() !== 'select'){
			return '12';
		}else{
		}

		for(idx=0; idx<values.length; idx++){
			selExFlag = false;

			$(htmlObj).children().each(function(){
				if(values[idx].value === this.value &&
				   values[idx].selected === true){
					selExFlag = true;
					selVals.push(values[idx].value);
				}else{
				}
			});

			if(!selExFlag){
				$(htmlObj).append($('<option>').attr({ value: values[idx].value }).text(values[idx].viewText));

				if(values[idx].selected){
					selVals.push(values[idx].value);
				}else{
				}
			}
		}

		if(selVals.length > 0){
			$(htmlObj).val(selVals);
		}else{
		}

		setVisibleAbled(htmlObj, visible[0], abled[0]);
	}

	return '0';
}

/******************
 * 表示・活性制御
 ******************/
function setVisibleAbled(htmlObj, visible, abled){
	if(visible === 1){
		$(htmlObj).show();
	}else if(visible === 2){
		$(htmlObj).hide();
	}else{
	}

	if(abled === 1){
		$(htmlObj).removeProp("disabled");
	}else if(abled === 2){
		$(htmlObj).prop("disabled", true);
	}else{
	}
}

/********************
 * 繰り返し項目編集
 ********************/
function setRepeatData(parentNode, editRepeat, refStr, elmtErrData) {
	var propertyName;
	var nodes;
	var returnCode;

	for (propertyName in editRepeat) {
		nodes = parentNode.find('#' + propertyName);

		if (nodes.length !== 0) {
			nodes.each(function() {
				switch (nodes.prop('tagName').toLowerCase()) {
				case 'tr':
					returnCode = repeatTable(this, editRepeat[propertyName],
							refStr, elmtErrData);
					break;
				case 'div':
				case 'fieldset':
				default:
					returnCode = repeatElement(this, editRepeat[propertyName],
							refStr, elmtErrData);
					break;
				}

				if (returnCode !== '0') {
					elmtErrData.push([ returnCode, propertyName ]);
				} else {
				}
			});
		} else {
			elmtErrData.push([ '20', propertyName ]);
		}
	}
}

/*****************
 * table要素複製
 *****************/
function repeatTable(htmlObj, rowItems, refStr, elmtErrData) {
	var cloneNode;
	var idx;

	if ((rowItems[0]['EDIT_SIMPLE'] === undefined)
			&& (rowItems[0]['EDIT_REPEAT'] === undefined)) {
		for (idx = 0; idx < rowItems.length; idx++) {
			cloneNode = $(htmlObj).clone();
			setSimpleData(cloneNode, rowItems[idx], (refStr + '_' + idx),
					elmtErrData);
			cloneNode.attr({
				id : (cloneNode.attr('id') + refStr + '_' + idx)
			});
			cloneNode.show();
			$(htmlObj).before(cloneNode);
		}

		$(htmlObj).hide();
	} else {
		return '22';
	}

	return '0';
}

/***************
 * div要素複製
 ***************/
function repeatElement(htmlObj, patternItems, refStr, elmtErrData) {
	var cloneNode;
	var idx;

	if ((patternItems[0]['EDIT_SIMPLE'] !== undefined)
			&& (patternItems[0]['EDIT_REPEAT'] !== undefined)) {
		for (idx = 0; idx < patternItems.length; idx++) {
			cloneNode = $(htmlObj).clone();
			setSimpleData(cloneNode, patternItems[idx]['EDIT_SIMPLE'], (refStr
					+ '_' + idx), elmtErrData);
			setRepeatData(cloneNode, patternItems[idx]['EDIT_REPEAT'], (refStr
					+ '_' + idx), elmtErrData);
			cloneNode.attr({
				id : (cloneNode.attr('id') + refStr + '_' + idx)
			});
			cloneNode.show();
			$(htmlObj).before(cloneNode);
		}

		$(htmlObj).hide();
	} else {
		return '21';
	}

	return '0';
}

/********************
 * UIコンテンツ追加
 ********************/
function addControl(partsData) {
	var elmtErrData;
	var ctrlData;
	var editData;
	var prtIdx;
	var nodeID;
	var editIdx;
	var targetNode;
	var templateNode;
	var editNode;
	var templateClone;
	var editClone;
	var attributeName;
	var attribute;
	var checked;

	elmtErrData = [];

	for (prtIdx = 0; prtIdx < partsData.length; prtIdx++) {
		if ((ctrlData = partsData[prtIdx]['ADD_CONTROL']) === undefined) {
			continue;
		} else {
		}

		templateNode = $('body').find('#' + ctrlData['templateID']);
		if (templateNode.length !== 1) {
			elmtErrData.push([ '30', ctrlData['templateID'] ]);
			continue;
		} else {
		}

		targetNode = $('body').find('#' + ctrlData['targetID']);
		if (targetNode.length !== 1) {
			elmtErrData.push([ '31', ctrlData['targetID'] ]);
			continue;
		} else {
		}

		templateClone = templateNode.clone();

		for (nodeID in ctrlData) {
			if (nodeID === 'templateID' || nodeID === 'targetID') {
				continue;
			} else {
			}

			editNode = templateClone.find('#' + nodeID);
			if (editNode.length !== 1) {
				elmtErrData.push([ '32', nodeID ]);
				continue;
			} else {
			}

			editData = ctrlData[nodeID];

			for (editIdx = 0; editIdx < editData.length; editIdx++) {
				switch (editNode.prop('tagName').toLowerCase()) {
				case 'input':
					if (editData[editIdx].type === undefined) {
						elmtErrData.push([ '33', nodeID ]);
						continue;
					} else {
					}

					switch (editData[editIdx].type.toLowerCase()) {
					case 'text':
					case 'password':
					case 'button':
						if (editData[editIdx].name === undefined || editData[editIdx].id === undefined) {
							elmtErrData.push([ '33', nodeID ]);
							continue;
						} else {
						}
						break;
					case 'checkbox':
					case 'radio':
						if (editData[editIdx].name === undefined ||
							editData[editIdx].id === undefined ||
							editData[editIdx].value === undefined) {
							elmtErrData.push([ '33', nodeID ]);
							continue;
						} else {
						}
						break;
					default:
						if (editData[editIdx].id === undefined) {
							elmtErrData.push([ '33', nodeID ]);
							continue;
						} else {
						}
						break;
					}
					break;
				case 'img':
					if (editData[editIdx].id === undefined || editData[editIdx].src === undefined) {
						elmtErrData.push([ '33', nodeID ]);
						continue;
					} else {
					}
					break;
				case 'select':
					if ((editData[editIdx].value !== undefined && editData[editIdx].viewText === undefined) ||
						(editData[editIdx].value === undefined && editData[editIdx].viewText !== undefined)) {
						elmtErrData.push([ '33', nodeID ]);
						continue;
					} else {
					}

					if ((editData[editIdx].name !== undefined && editData[editIdx].id === undefined) ||
						(editData[editIdx].name === undefined && editData[editIdx].id !== undefined)) {
						elmtErrData.push([ '33', nodeID ]);
						continue;
					} else {
					}
					break;
				default:
					if (editData[editIdx].id === undefined) {
						elmtErrData.push([ '33', nodeID ]);
						continue;
					} else {
					}
					break;
				}

				attribute = {};
				checked = false;
				for (attributeName in editData[editIdx]) {
					if (attributeName !== 'viewText') {
						if (attributeName === 'checked'){
							checked = true;
						}else{
							attribute[attributeName] = 
								editData[editIdx][attributeName];
						}
					} else {
					}
				}

				if (editNode.prop('tagName').toLowerCase() === 'select') {
					if (editData[editIdx].value !== undefined &&
						editData[editIdx].viewText !== undefined) {
						editNode.append($('<option>')
						.attr(attribute)
						.text(editData[editIdx].viewText));
					} else {
						editNode.attr(attribute);
					}
				} else {
					editClone = editNode.clone();
					editClone.attr(attribute);
					if (editData[editIdx].viewText !== undefined) {
						if(editNode.prop('tagName').toLowerCase() === 'textarea'){
							editClone.val(editData[editIdx].viewText);
						}else{
							editClone.html(editData[editIdx].viewText);
						}
					} else {
					}
					if (checked){
						editClone.prop('checked', true);
					} else {
					}

					editNode.before(editClone.show());
					editNode.remove();
				}
			}
		}

		templateClone.children().each(function() {
			targetNode.append($(this));
		});
	}

	// トリム設定(画面表示項目が生成されたのちに実施)
	$('input[type="text"]').on("change" , function(){
		$(this).val($.trim($(this).val()));
	});
	$('input[type="tel"]').on("change" , function(){
		$(this).val($.trim($(this).val()));
	});
	$('textarea').on("change" , function(){
		$(this).val($.trim($(this).val()));
	});

	if (elmtErrData.length > 0) {
		return makeCBErrData(2, 'addControlErr', elmtErrData);
	} else {
		return makeCBErrData(0, '', elmtErrData);
	}
}

/**************
 * データ送信
 **************/
function sendData(url, callbackFnc, apcParam_verbs, apcParam_bean, apcParam_gid, apcParam_func, paramA,paramB) {
	var idElement;
	var dataArray;
	var uji_id;
	var uji_encoding;
	var __sid;
	var __uid;
	var __agttranid;
	var sendData;
	var sendTimeout;

//	if (typeof url !== 'string' || url === '') {
//		return 1;
//	}

	if (callbackFnc != null && typeof (callbackFnc) !== 'function') {
		return 1;
	}

	if (typeof apcParam_verbs !== 'string' || apcParam_verbs === '') {
		return 1;
	}

	if (typeof apcParam_bean !== 'string' || apcParam_bean === '') {
		return 1;
	}

	if (typeof apcParam_gid !== 'string' || apcParam_gid === '') {
		return 1;
	}

	if (typeof apcParam_func !== 'string' || apcParam_func === '') {
		return 1;
	}

	if (typeof paramA === 'string') {
		idElement = $('#' + paramA);
		if (idElement.length <= 0) {
			return 1;
		}
	} else if (typeof paramA === 'object') {
		for (var i = 0; i < paramA.length; i++) {
			if (paramA[i][0] === '') {
				return 1;
			}
		}
		dataArray = paramA;
	} else {
		return 1;
	}

	if (typeof paramB !== 'undefined') {
		if (typeof paramB === 'object' && typeof paramA === 'string') {
			for (var i = 0; i < paramB.length; i++) {
				if (paramB[i][0] === '') {
					return 1;
				}
			}
			dataArray = paramB;
		} else {
			return 1;
		}
	}

	uji_id = 'bodyBean';
	uji_encoding = 'none';

	var commonData = getCommonData();
	if (commonData == null) {
		return 2;
	} else {
		__sid = commonData.sessionId;
		__uid = commonData.userId;
	}

	var tranData = getTranData();
	if (tranData == null) {
		return 2;
	} else {
		__agttranid = tranData.tranId;
	}

	sendData = makeSendPOSTData(idElement, dataArray);

	sendData += '&__sid=' + __sid + '&__uid=' + __uid;
	sendData += '&__agttranid=' + __agttranid;
	sendData += '&ajaxFlag=true';
	sendData += '&uji.id=' + uji_id;
	sendData += '&uji.encoding=' + uji_encoding;
	sendData += '&uji.verbs=' + apcParam_verbs;
	sendData += '&uji.bean=' + apcParam_bean;
	sendData += '&__gid=' + apcParam_gid;
	sendData += '&__func=' + apcParam_func;

	if (callbackFnc == null) {
		sendTimeout = 0;
	} else {
		sendTimeout = 900000;
	}

	callAjax(url, sendData, sendTimeout, callbackFnc, 1);
}

function callAjax(url, sendData, sendTimeout, callbackFnc ,count) {
//	$.ajax({
//		type : 'POST',
//		url : url,
//		data : sendData,
//		cache : false,
//		timeout : sendTimeout,
//
//		success : function(data, dataType) {
//
//			if(callbackFnc === null){
//				return;
//			}
//
//			var isError = false;
//			if (data instanceof Array) {
//				for (var i = 0; i < data.length; i++) {
//					if (typeof data[i] === 'undefined' || data[i] == null) {
//						isError = true;
//						break;
//					}
//				}
//				if (!isError
//						&& (data[0].returnCode === 'undefined' || data[0].returnCode == null)) {
//					isError = true;
//				}
//
//				if (isError) {
//					cbErr = makeCBErrData('5', 'responseDataErr', null);
//					callbackFnc(null, cbErr, null, null);
//				} else {
//					if (setCommonData(data[2]) != 0) {
//						data[1].clientReturnCode = '1';
//						data[1].clientErrMsg = 'setCommondataErr';
//					}
//
//					var serverReturnCode = data[0].returnCode;
//					if (serverReturnCode === '0' || serverReturnCode === '2') {
//						if(data[1].clientReturnCode === ''){
//							data[1].clientReturnCode = '0';
//						}
						var data = new Array();
						data[0] = '{errDate: "H30/6/4 20:21:51", __uid: "30999990001", __sid: "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", __gid: variable.id, __func: "", errCd: "", errMsg: "", returnCode: "0"}';
						data[1] = '{clientReturnCode: "0", clientErrMsg: "", elmtErrData: Array[0]}';
						data[2] = '{sessionId: "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", userId: "30999990001"}';
						data[3] = new Array();

						data[3]['EDIT_ITEMS'] = new Array();
						data[3]['EDIT_ITEMS'][0] = new Array();
						data[3]['EDIT_ITEMS'][1] = new Array();

						data[3]['IDV_DATA'] = new Array();
						data[3]['IDV_DATA'][0] = new Array();
						data[3]['IDV_DATA'][1] = new Array();

						callbackFnc(data[0], data[1], data[2], data[3]);
//					} else {
//						showCommonErrorPage(data[0]);
//					}
//				}
//			} else {
//				showCommonErrorPage(data);
//			}
//		},
//		error : function(XMLHTTPRequest, textStatus, errorThrown) {
//			switch (textStatus) {
//			case 'parsererror':
//				if (callbackFnc != null) {
//					var cbErr = makeCBErrData('4', 'parserErr', null);
//					callbackFnc(null, cbErr, null, null);
//				}
//				break;
//			case 'timeout':
//				if (callbackFnc != null) {
//					location.href = './GPLYL0E00.html';
//				}
//				break;
//			default:
//				if (XMLHTTPRequest && XMLHTTPRequest.status && XMLHTTPRequest.status >= 400 && XMLHTTPRequest.status < 600) {
//					location.href = './GPLYL0E01.html';
//				} else {
//					sendData += '&ajaxErrorRetry' + count + '=' + XMLHTTPRequest.status;
//					count++;
//					if(count < 7) {
//						callAjax(url, sendData, sendTimeout, callbackFnc ,count);
//					} else {
//
//						if(confirm("通信エラーが発生しました。\n通信をリトライしますか？\n\n※通信環境が良い場所でご利用ください。\n※「キャンセル」すると終了します。\n　入力途中のデータは、再度入力いただく場合があります。")){
//							callAjax(url, sendData, sendTimeout, callbackFnc ,count);
//						} else {
//							location.href = './GPLYL0E02.html';
//						}
//					}
//				}
//				break;
//			}
//		}
//	});
}

/************************
 * ディレイド用データ送信
 ************************/
function sendDelayedData(url, callbackFnc, apcParam_verbs, apcParam_bean, apcParam_gid, apcParam_func, paramA,paramB) {
	var idElement;
	var dataArray;
	var uji_id;
	var uji_encoding;
	var __sid;
	var __uid;
	var __agttranid;
	var sendData;
	var sendTimeout;

	if (typeof url !== 'string' || url === '') {
		return 1;
	}

	if (callbackFnc != null && typeof (callbackFnc) !== 'function') {
		return 1;
	}

	if (typeof apcParam_verbs !== 'string' || apcParam_verbs === '') {
		return 1;
	}

	if (typeof apcParam_bean !== 'string' || apcParam_bean === '') {
		return 1;
	}

	if (typeof apcParam_gid !== 'string' || apcParam_gid === '') {
		return 1;
	}

	if (typeof apcParam_func !== 'string' || apcParam_func === '') {
		return 1;
	}

	if (typeof paramA === 'string') {
		idElement = $('#' + paramA);
		if (idElement.length <= 0) {
			return 1;
		}
	} else if (typeof paramA === 'object') {
		for (var i = 0; i < paramA.length; i++) {
			if (paramA[i][0] === '') {
				return 1;
			}
		}
		dataArray = paramA;
	} else {
		return 1;
	}

	if (typeof paramB !== 'undefined') {
		if (typeof paramB === 'object' && typeof paramA === 'string') {
			for (var i = 0; i < paramB.length; i++) {
				if (paramB[i][0] === '') {
					return 1;
				}
			}
			dataArray = paramB;
		} else {
			return 1;
		}
	}

	uji_id = 'bodyBean';
	uji_encoding = 'none';

	var commonData = getCommonData();
	if (commonData == null) {
		return 2;
	} else {
		__sid = commonData.sessionId;
		__uid = commonData.userId;
	}

	var tranData = getTranData();
	if (tranData == null) {
		return 2;
	} else {
		__agttranid = tranData.tranId;
	}

	sendData = makeSendPOSTData(idElement, dataArray);

	sendData += '&__sid=' + __sid + '&__uid=' + __uid;
	sendData += '&__agttranid=' + __agttranid;
	sendData += '&ajaxFlag=true';
	sendData += '&uji.id=' + uji_id;
	sendData += '&uji.encoding=' + uji_encoding;
	sendData += '&uji.verbs=' + apcParam_verbs;
	sendData += '&uji.bean=' + apcParam_bean;
	sendData += '&__gid=' + apcParam_gid;
	sendData += '&__func=' + apcParam_func;

	if (callbackFnc == null) {
		sendTimeout = 0;
	} else {
		sendTimeout = 900000;
	}

	callDelayedAjax(url, sendData, sendTimeout, callbackFnc ,1);
}

function callDelayedAjax(url, sendData, sendTimeout, callbackFnc ,count) {
	$.ajax({
		type : 'POST',
		url : url,
		data : sendData,
		timeout : sendTimeout,

		success : function(data, dataType) {
			return;
		},
		error : function(XMLHTTPRequest, textStatus, errorThrown) {
			if (XMLHTTPRequest && XMLHTTPRequest.status && XMLHTTPRequest.status >= 400 && XMLHTTPRequest.status < 600) {
				return ;
			} else {
				sendData += '&ajaxDelayErrorRetry' + count + '=' + XMLHTTPRequest.status;
				count++;
				if(count < 7) {
					callDelayedAjax(url, sendData, sendTimeout, callbackFnc ,count);
				} else {

					if(confirm("通信エラーが発生しました。\n通信をリトライしますか？\n\n※通信環境が良い場所でご利用ください。\n※「キャンセル」すると終了します。\n　入力途中のデータは、再度入力いただく場合があります。")){
						callDelayedAjax(url, sendData, sendTimeout, callbackFnc ,count);
					}
				}
			}
			return;
		}
	});
}

/**********************
 * POST送信データ生成
 **********************/
function makeSendPOSTData(domParentElm, exDataArray) {
	var sendData = '';

	if (domParentElm != null) {
		switch (domParentElm[0].tagName.toLowerCase()) {
		case 'form':
			sendData = domParentElm.serialize();
			break;
		default:
			domParentElm.find(':input').each(function() {
				switch (this.tagName.toLowerCase()) {
				case 'form':
					break;
				default:
					var data = $(this).serialize();
					if (data) {
						if (sendData != null) {
							sendData += '&' + data;
						} else {
							sendData = data;
						}
					}
					break;
				}
			});
			break;
		}
	}

	if (exDataArray != null) {
		for (var i = 0; i < exDataArray.length; i++) {
			if (sendData != null) {
				sendData += '&' + encodeURIComponent(exDataArray[i][0]) + '='
						+ encodeURIComponent(exDataArray[i][1]);
			} else {
				sendData = encodeURIComponent(exDataArray[i][0]) + '='
						+ encodeURIComponent(exDataArray[i][1]);
			}
		}
	}

	return sendData;
}

/******************************
 * クライアントエラー情報生成
 ******************************/
function makeCBErrData(clientreturnCode, clienterrMsg, elmtErrData) {
	var cbErrorData = {
		clientReturnCode : clientreturnCode,
		clientErrMsg : clienterrMsg,
		elmtErrData : elmtErrData
	}
	return cbErrorData;
}

/**********************
 * 共通エラー画面遷移
 **********************/
function showCommonErrorPage(errorInfo) {
	var errForm = document.createElement('form');

	var url = location.href;
	var separator = '/';
	url = url.substring(0, url.lastIndexOf(separator));
	var directorys = url.split(separator);
	var lastDirectory = directorys[directorys.length - 1];
	if(lastDirectory === 'contents') {
		errForm.action = '../../common/GAXR00000.jsp';
	} else {
		errForm.action = '../../../common/GAXR00000.jsp';
	}
	
	errForm.method = 'post';

	for ( var key in errorInfo) {
		if (key !== 'returnCode') {
			var input = document.createElement('input');
			input.setAttribute('name', key);
			input.setAttribute('value', errorInfo[key]);
			input.setAttribute('type', 'hidden');
			errForm.appendChild(input);
		}
	}

	var ajaxFlag = document.createElement('input');
	ajaxFlag.setAttribute('name', 'ajaxFlag');
	ajaxFlag.setAttribute('value', 'false');
	ajaxFlag.setAttribute('type', 'hidden');
	errForm.appendChild(ajaxFlag);

	var uji_bean = document.createElement('input');
	uji_bean.setAttribute('name', 'uji.bean');
	uji_bean.setAttribute('value',
			'jp.co.nksjhimawari.ho.common.HocCommonErrorBean');
	uji_bean.setAttribute('type', 'hidden');
	errForm.appendChild(uji_bean);

	var uji_verb = document.createElement('input');
	uji_verb.setAttribute('name', 'uji.verb');
	uji_verb.setAttribute('value', 'disperrorpage');
	uji_verb.setAttribute('type', 'hidden');
	errForm.appendChild(uji_verb);

	document.body.appendChild(errForm);
	errForm.submit();
}

/**************************
 * キャッシュイベント設定
 **************************/
function setCacheEvent() {
	var prgPop;
	var errPop;

	if (window.applicationCache) {
		window.applicationCache.addEventListener('downloading', function() {
			prgPop = createCacheProgressPop();
			prgPop.popup().popup('open');
		});

		window.applicationCache.addEventListener('progress',function(e){
			prgPop.popup('open');
			updateCacheProgressPop(e);
		});

		window.applicationCache.addEventListener('updateready', function() {
			window.applicationCache.swapCache();
			prgPop.popup('close');
		});

		window.applicationCache.addEventListener('error', function(e) {
			prgPop.popup('close');
			errPop = createCacheErrPop();
			errPop.popup().popup('open');
		});

		window.applicationCache.addEventListener('cached', function() {
			prgPop.popup('close');
		});
	} else {
	}
}

/**************************
 * キャッシュ進捗画面作成
 **************************/
function createCacheProgressPop(){
	var baseNode;
	var titleNode;
	var messageNode;

	baseNode = $('<DIV>').attr({
		'id' : 'appCacheProgressPop',
		'data-role' : 'popup',
		'data-theme' : 'a',
		'data-overlay-theme' : 'b',
		'data-dismissible' : false,
		'data-history' : false,
		'class' : 'container appcache-prgpop-base'
	});

	titleNode = $('<H3>').attr({
		'class' : 'appcache-prgpop-msg'
	}).text(
		'コンテンツを更新中です'
	);

	messageNode = $('<H3>').attr({
		'class' : 'appcache-prgpop-msg'
	}).html(
		'<SPAN id="appCacheLoaded">0</SPAN>' + '　％</H3>'
	);

	baseNode.append(titleNode);
	baseNode.append(messageNode);

	return baseNode;
}

/**************************
 * キャッシュ進捗画面更新
 **************************/
function updateCacheProgressPop(pEvent){
	$('#appCacheLoaded').text(
		Math.floor(pEvent.loaded / pEvent.total * 100)
	);
}

/****************************
 * キャッシュエラー画面作成
 ****************************/
function createCacheErrPop(){
	var baseNode;
	var messageNode;
	var spaceNode;
	var buttonNode;

	baseNode = $('<DIV>').attr({
		'id' : 'appCacheErrPop',
		'data-role' : 'popup',
		'data-theme' : 'a',
		'data-overlay-theme' : 'b',
		'data-dismissible' : false,
		'data-history' : false,
		'class' : 'container appcache-errpop-base'
	});

	messageNode = $('<DIV>').html(cbDefines.appCashMessage);
	spaceNode = $('<P>').attr({
		'class' : 'cnt fw-normal mb20'
	});

	buttonNode = $('<DIV>').attr({
		'class' : 'yes-no mb00 clearfix'
	}).html(
		'<a href="#" class="btn-red arrow fl mb20"' +
		'id="reload-btn" tabindex="100"><p class="cnt2">再実行する</p></a>' +
		'<a href="#" class="btn-blue arrow fr mb20"' +
		'id="close-btn" tabindex="200"><p class="cnt">中止する</p></a>'
	);
	buttonNode.find('#reload-btn').each(function(){
		$(this).click(function(){
			baseNode.popup('close');
		});
	});
	buttonNode.find('#close-btn').each(function(){
		$(this).click(function(){
			baseNode.popup('close');
			window.open('about:blank','_self').close();
		});
	});

	baseNode.append(messageNode);
	baseNode.append(spaceNode);
	baseNode.append(buttonNode);

	return baseNode;
}

/******************
 * 画像サイズ制御
 ******************/
function changeImageSrc(imageMapping, domId){
	var errCode;
	var parentNode;
	var dpRatio;
	var realWidth;
	var mapData;
	var propertyName;
	var resolution;
	var rgxResult;
	var filepath;

	if(domId === null || domId === ''){
		parentNode = $('body');
	}
	else if(typeof(domId) === 'string'){
		parentNode = $('#' + domId);

		if(parentNode.length === 0){
			return 1;
		}
	}
	else{
		return 1;
	}

	if(imageMapping == null || typeof(imageMapping) !== 'object'){
		return 1;
	}

	if(!window.devicePixelRatio){
		dpRatio = window.screen.deviceXDPI / window.screen.logicalXDPI;
	}
	else{
		dpRatio = window.devicePixelRatio;
	}

	realWidth = $(window).width() * dpRatio;

	parentNode.find('img[mappingGroup][filename]').each(function(){
		mapData = imageMapping[$(this).attr('mappingGroup')];

		if(!mapData){
			errCode = 2;
			return true;
		}
		for(propertyName in mapData){
			if(typeof(mapData[propertyName]) !== 'string' || mapData[propertyName] === ''){
				errCode = 2;
				continue;
			}

			rgxResult = /S[0-9]+/g.exec(propertyName);

			if(rgxResult){
				if(rgxResult[0].length === propertyName.length){
					resolution = parseInt(propertyName.substring(1, propertyName.length));
				}
				else{
					continue;
				}
			}
			else{
				continue;
			}

			if(realWidth >= resolution){
				continue;
			}
			else{
				filepath = mapData[propertyName];
				break;
			}
		}

		if(!filepath){
			if(!mapData['default']){
				errCode = 2;
				return true;
			}
			else{
				filepath = mapData['default'];
			}
		}

		$(this).attr({src : filepath + $(this).attr('filename')});
	});

	if(errCode){
		return errCode;
	}
	else{
		return 0;
	}
}

/***********
 * URL変換
 ***********/
function convertUrl(urlMapping, defUrl) {
	var inputPath;
	var inputFileName;
	var inputPageID;
	var slashIdx;
	var sharpIdx;
	var urlMap;
	var urlMapIdx;
	var mapInf;
	var transitionUrl;

	if(typeof(defUrl) !== 'string' || defUrl === ''){
		return 1;
	}

	if(urlMapping == null || typeof(urlMapping) !== 'object'){
		return 1;
	}

	slashIdx = defUrl.lastIndexOf('/');
	sharpIdx = defUrl.lastIndexOf('#');

	if(slashIdx >= 0){
		inputPath = defUrl.substring(0, (slashIdx + 1));

		if(inputPath.substring(0, 3) !== '../'){
			return 2;
		}
	}
	else{
		inputPath = '';
	}

	if(sharpIdx >= 0){
		inputPageID = defUrl.substring(sharpIdx, defUrl.length);
	}
	else{
		inputPageID = '';
	}

	inputFileName = defUrl;

	inputFileName = inputFileName.replace(new RegExp(inputPath), '');
	inputFileName = inputFileName.replace(new RegExp(inputPageID), '');

	if(!inputFileName){
		if(inputPath){
			return 2;
		}
		else{
			inputFileName = window.location.href.split('/').pop();
		}
	}

	if(inputFileName.substring(inputFileName.length - 5, inputFileName.length) === '.html'){
		inputFileName = inputFileName.substring(0, inputFileName.length - 5);
	}
	else{
		return 2;
	}

	if(!inputFileName){
		return 2;
	}

	if((urlMap = urlMapping[inputFileName]) === undefined){
		urlMap = urlMapping['default'];
		if(!urlMap){
			return 3;
		}
	}

	for(urlMapIdx in urlMap){
		if(!urlMap[urlMapIdx].regex || !urlMap[urlMapIdx].ver || !urlMap[urlMapIdx].cvtPtrn){
			return 3;
		}

		if(!Array.isArray(urlMap[urlMapIdx].regex) ||
		   typeof(urlMap[urlMapIdx].ver) !== 'string' ||
		   typeof(urlMap[urlMapIdx].cvtPtrn) !== 'string'){
			return 3;
		}

		if(navigator.userAgent.match(urlMap[urlMapIdx].regex)){
			mapInf = urlMap[urlMapIdx];
			break;
		}
	}

	if(!mapInf){
		for(urlMapIdx in urlMap){
			if(urlMap[urlMapIdx].regex[0] === 'default'){
				mapInf = urlMap[urlMapIdx];
				break;
			}
		}
	}

	if(!mapInf){
		return 3;
	}

	try{
	    transitionUrl = convertFileName(inputFileName, inputPageID, mapInf.cvtPtrn);
		if(transitionUrl === ''){
			return 3;
		}
		transitionUrl = '../' + inputPath + mapInf.ver + '/' + transitionUrl;
	}catch(e){
		return 3;
	}

	if(window.location.href.match('.+/(.+?)\.[a-z]+([\?#;].*)?$') === null){
		location.href = transitionUrl;
	}else if(inputFileName === window.location.href.match('.+/(.+?)\.[a-z]+([\?#;].*)?$')[1]){
		$.mobile.pageContainer.pagecontainer('change', transitionUrl);
	}else{
		location.href = transitionUrl;
	}
}

/************
 * 画面遷移
 ************/
function convertFileName(fileName, pageID, cvtPtrn) {
	var page = pageID.substring(1, pageID.length);

	switch(cvtPtrn){
	case '1':
		if(pageID === ''){
			return fileName + '.html';
		}else{
			return fileName + '.html#' + page;
		}
		break;
	case '2':
		if(pageID === ''){
			return fileName + '.html';
		}else{
			return fileName + '_' + page + '.html';
		}
		break;
	default:
		return '';
	}
}

/*****************
 *  リダイレクト
 *****************/
function redirect(sId, uId, redirectUrl, urlMapping){
    var commonData = '{"sessionId":"' + sId + '", "userId":"' + uId + '"}';
	var commonDataJson = JSON.parse(commonData);
	var result = setCommonData(commonDataJson);
	var isError = false;

	if(result == 0){
		var tranResult = setTranData();
		if(tranResult == 0){
			if(convertUrl(urlMapping, redirectUrl) !==  undefined){
				isError = true;
			}
		}else{
			isError = true;
		}
	}else{
		isError = true;
	}

	if(isError){
	    var cbErrorData = '{"errData":"","__uid":"' + uId + '","__sid":"' + sId +
	    '","__gid":"","__func":"","errCd":"","errMsg":"","returnCode":""}';
	    showCommonErrorPage(JSON.parse(cbErrorData));
	}
}

/**********************
 * メールアドレス設定
 **********************/
function setMailaddressData(mailaddressdata) {

	var strName = 'agtMailaddressData';
	var strValdata = '';
	var strPath = '';

	var setDay = new Date();

	if (mailaddressdata == null) {
		return 1;
	}

	if (mailaddressdata.nyuryoku === undefined || mailaddressdata.kakunin === undefined) {
		return 1;
	}

	if (Object.getOwnPropertyNames(mailaddressdata).length > 2) {
		return 1;
	}

	if (mailaddressdata.nyuryoku == null || mailaddressdata.kakunin == null) {
		return 1;
	}

	if (typeof (mailaddressdata.nyuryoku) != 'string'
			|| typeof (mailaddressdata.kakunin) != 'string') {
		return 1;
	}

	if ((mailaddressdata.nyuryoku).trim() == "" || (mailaddressdata.kakunin).trim() == "") {
		return 1;
	}

	if (navigator.cookieEnabled == false) {
		return 2;
	}
	strValdata = JSON.stringify(mailaddressdata);

	strPath = make_PATH();

	document.cookie = strName + '=' + encodeURIComponent(strValdata) + ';Path='
			+ strPath + ';';

	return 0;
}

/**********************
 * メールアドレス取得
 **********************/
function getMailaddressData() {

	try {

		var name = 'agtMailaddressData'; // クッキーの名前

		var cookie_value = cookie_read(name);

		if (cookie_value == null) {
			return "";
		} else {

			var mailaddressdata = JSON.parse(cookie_value);

			if (mailaddressdata.nyuryoku === undefined || mailaddressdata.kakunin === undefined) {
				return "";
			}

			if (Object.getOwnPropertyNames(mailaddressdata).length > 2) {
				return "";
			}

			return mailaddressdata;
		}
	} catch (e) {
		return "";
	}
}

/**********************
 * メール送信フラグ設定
 **********************/
function setMailsoshinData(mailsoshindata) {

	var strName = 'agtMailsoshinData';
	var strValdata = '';
	var strPath = '';

	var setDay = new Date();

	if (mailsoshindata == null) {
		return 1;
	}

	if (mailsoshindata.fg === undefined) {
		return 1;
	}

	if (Object.getOwnPropertyNames(mailsoshindata).length > 1) {
		return 1;
	}

	if (mailsoshindata.fg == null) {
		return 1;
	}

	if (typeof (mailsoshindata.fg) != 'string') {
		return 1;
	}

	if ((mailsoshindata.fg).trim() == "") {
		return 1;
	}

	if (navigator.cookieEnabled == false) {
		return 2;
	}
	strValdata = JSON.stringify(mailsoshindata);

	strPath = make_PATH();

	document.cookie = strName + '=' + encodeURIComponent(strValdata) + ';Path='
			+ strPath + ';';

	return 0;
}

/**********************
 * メール送信フラグ取得
 **********************/
function getMailsoshinData() {

	try {

		var name = 'agtMailsoshinData'; // クッキーの名前

		var cookie_value = cookie_read(name);

		if (cookie_value == null) {
			return "";
		} else {

			var mailsoshindata = JSON.parse(cookie_value);

			if (mailsoshindata === undefined) {
				return "";
			}

			if (Object.getOwnPropertyNames(mailsoshindata).length > 1) {
				return "";
			}

			return mailsoshindata;
		}
	} catch (e) {
		return "";
	}
}
